/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.internal;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.exception.CommerceTaxEngineException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculateRequest;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.commerce.tax.CommerceTaxEngine;
import com.liferay.commerce.tax.CommerceTaxValue;
import com.liferay.commerce.tax.configuration.CommerceShippingTaxConfiguration;
import com.liferay.commerce.tax.model.CommerceTaxMethod;
import com.liferay.commerce.tax.service.CommerceTaxMethodLocalService;
import com.liferay.commerce.util.CommerceTaxEngineRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceTaxCalculation.class})
public class CommerceTaxCalculationImpl
implements CommerceTaxCalculation {
    private static final Log _log = LogFactoryUtil.getLog(CommerceTaxCalculationImpl.class);
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommerceTaxEngineRegistry _commerceTaxEngineRegistry;
    @Reference
    private CommerceTaxMethodLocalService _commerceTaxMethodLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public List<CommerceTaxValue> getCommerceTaxValues(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder == null) {
            return Collections.emptyList();
        }
        HashMap<String, CommerceTaxValue> taxValueMap = new HashMap<String, CommerceTaxValue>();
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            List<CommerceTaxValue> commerceTaxValues = this.getCommerceTaxValues(commerceOrder.getGroupId(), commerceOrderItem.getCPInstanceId(), commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), commerceOrderItem.getFinalPrice(), false);
            for (CommerceTaxValue commerceTaxValue : commerceTaxValues) {
                CommerceTaxValue aggregatedCommerceTaxValue = null;
                BigDecimal amount = commerceTaxValue.getAmount();
                if (taxValueMap.containsKey(commerceTaxValue.getName())) {
                    aggregatedCommerceTaxValue = (CommerceTaxValue)taxValueMap.get(commerceTaxValue.getName());
                    amount = amount.add(aggregatedCommerceTaxValue.getAmount());
                }
                aggregatedCommerceTaxValue = new CommerceTaxValue(commerceTaxValue.getName(), commerceTaxValue.getLabel(), amount);
                taxValueMap.put(commerceTaxValue.getName(), aggregatedCommerceTaxValue);
            }
        }
        return new ArrayList<CommerceTaxValue>(taxValueMap.values());
    }

    @Deprecated
    public List<CommerceTaxValue> getCommerceTaxValues(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceTaxValues(commerceOrder);
    }

    public List<CommerceTaxValue> getCommerceTaxValues(long groupId, long cpInstanceId, long commerceBillingAddressId, long commerceShippingAddressId, BigDecimal amount, boolean includeTax) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (cpDefinition.isTaxExempt() || cpDefinition.getCPTaxCategoryId() <= 0L) {
            return Collections.emptyList();
        }
        return this._getCommerceTaxValues(groupId, commerceBillingAddressId, commerceShippingAddressId, amount, includeTax, cpDefinition.getCPTaxCategoryId());
    }

    @Deprecated
    public List<CommerceTaxValue> getCommerceTaxValues(long groupId, long cpInstanceId, long commerceBillingAddressId, long commerceShippingAddressId, BigDecimal amount, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceTaxValues(groupId, cpInstanceId, commerceBillingAddressId, commerceShippingAddressId, amount, false);
    }

    public CommerceMoney getShippingTaxValue(CommerceOrder commerceOrder, CommerceCurrency commerceCurrency) throws PortalException {
        CommerceShippingTaxConfiguration commerceShippingTaxConfiguration = (CommerceShippingTaxConfiguration)this._configurationProvider.getConfiguration(CommerceShippingTaxConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceOrder.getGroupId(), "com.liferay.commerce.tax"));
        List<CommerceTaxValue> commerceTaxValues = this._getCommerceTaxValues(commerceOrder.getGroupId(), commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), commerceOrder.getShippingAmount(), false, commerceShippingTaxConfiguration.taxCategoryId());
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (commerceTaxValues != null) {
            for (CommerceTaxValue commerceTaxValue : commerceTaxValues) {
                taxAmount = taxAmount.add(commerceTaxValue.getAmount());
            }
        }
        return this._commerceMoneyFactory.create(commerceCurrency, taxAmount);
    }

    @Deprecated
    public CommerceMoney getTaxAmount(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTaxAmount(commerceOrder, commerceContext.getCommerceCurrency());
    }

    public CommerceMoney getTaxAmount(CommerceOrder commerceOrder, CommerceCurrency commerceCurrency) throws PortalException {
        BigDecimal taxAmount = BigDecimal.ZERO;
        List<CommerceTaxValue> commerceTaxValues = this.getCommerceTaxValues(commerceOrder);
        for (CommerceTaxValue commerceTaxValue : commerceTaxValues) {
            taxAmount = taxAmount.add(commerceTaxValue.getAmount());
        }
        return this._commerceMoneyFactory.create(commerceCurrency, taxAmount);
    }

    private List<CommerceTaxValue> _getCommerceTaxValues(long groupId, long commerceBillingAddressId, long commerceShippingAddressId, BigDecimal amount, boolean includeTax, long taxCategoryId) {
        ArrayList<CommerceTaxValue> commerceTaxValues = new ArrayList<CommerceTaxValue>();
        CommerceTaxCalculateRequest commerceTaxCalculateRequest = new CommerceTaxCalculateRequest();
        commerceTaxCalculateRequest.setCommerceBillingAddressId(commerceBillingAddressId);
        commerceTaxCalculateRequest.setCommerceShippingAddressId(commerceShippingAddressId);
        commerceTaxCalculateRequest.setPrice(amount);
        commerceTaxCalculateRequest.setIncludeTax(includeTax);
        commerceTaxCalculateRequest.setChannelGroupId(groupId);
        commerceTaxCalculateRequest.setTaxCategoryId(taxCategoryId);
        List commerceTaxMethods = this._commerceTaxMethodLocalService.getCommerceTaxMethods(groupId, true);
        for (CommerceTaxMethod commerceTaxMethod : commerceTaxMethods) {
            commerceTaxCalculateRequest.setCommerceTaxMethodId(commerceTaxMethod.getCommerceTaxMethodId());
            commerceTaxCalculateRequest.setPercentage(commerceTaxMethod.isPercentage());
            CommerceTaxEngine commerceTaxEngine = this._commerceTaxEngineRegistry.getCommerceTaxEngine(commerceTaxMethod.getEngineKey());
            try {
                CommerceTaxValue commerceTaxValue = commerceTaxEngine.getCommerceTaxValue(commerceTaxCalculateRequest);
                if (commerceTaxValue == null) continue;
                commerceTaxValues.add(commerceTaxValue);
            }
            catch (CommerceTaxEngineException commerceTaxEngineException) {
                _log.error((Object)commerceTaxEngineException, (Throwable)commerceTaxEngineException);
            }
        }
        return commerceTaxValues;
    }
}

