/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.decode;

import com.networknt.config.Config;
import com.networknt.decode.RequestDecodeConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.conduits.GzipStreamSourceConduit;
import io.undertow.conduits.InflatingStreamSourceConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import java.util.List;
import java.util.Map;
import org.xnio.conduits.StreamSourceConduit;

public class RequestDecodeHandler
implements MiddlewareHandler {
    public static RequestDecodeConfig config = (RequestDecodeConfig)Config.getInstance().getJsonObjectConfig("request-decode", RequestDecodeConfig.class);
    private final Map<String, ConduitWrapper<StreamSourceConduit>> requestEncodings = new CopyOnWriteMap();
    private volatile HttpHandler next;

    public RequestDecodeHandler() {
        List<String> decoders = config.getDecoders();
        for (int i = 0; i < decoders.size(); ++i) {
            String decoder = decoders.get(i);
            if ("deflate".equals(decoder)) {
                this.requestEncodings.put(decoder, (ConduitWrapper<StreamSourceConduit>)InflatingStreamSourceConduit.WRAPPER);
                continue;
            }
            if ("gzip".equals(decoder)) {
                this.requestEncodings.put(decoder, (ConduitWrapper<StreamSourceConduit>)GzipStreamSourceConduit.WRAPPER);
                continue;
            }
            throw new RuntimeException("Invalid decoder " + decoder + " for RequestDecodeHandler.");
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)RequestDecodeHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("request-decode"), null);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ConduitWrapper<StreamSourceConduit> encodings = this.requestEncodings.get(exchange.getRequestHeaders().getFirst(Headers.CONTENT_ENCODING));
        if (encodings != null && exchange.isRequestChannelAvailable()) {
            exchange.addRequestWrapper(encodings);
            exchange.getRequestHeaders().remove(Headers.CONTENT_ENCODING);
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }
}

