/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.encode;

import com.networknt.config.Config;
import com.networknt.encode.ResponseEncodeConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import java.util.List;
import java.util.Map;

public class ResponseEncodeHandler
implements MiddlewareHandler {
    public static ResponseEncodeConfig config = (ResponseEncodeConfig)Config.getInstance().getJsonObjectConfig("response-encode", ResponseEncodeConfig.class);
    static final String NO_ENCODING_HANDLER = "ERR10050";
    private final ContentEncodingRepository contentEncodingRepository = new ContentEncodingRepository();
    private volatile HttpHandler next;

    public ResponseEncodeHandler() {
        List<String> encoders = config.getEncoders();
        for (int i = 0; i < encoders.size(); ++i) {
            String encoder = encoders.get(i);
            if ("gzip".equals(encoder)) {
                this.contentEncodingRepository.addEncodingHandler(encoder, (ContentEncodingProvider)new GzipEncodingProvider(), 100);
                continue;
            }
            if ("deflate".equals(encoder)) {
                this.contentEncodingRepository.addEncodingHandler(encoder, (ContentEncodingProvider)new DeflateEncodingProvider(), 10);
                continue;
            }
            throw new RuntimeException("Invalid encoder " + encoder + " for ResponseEncodeHandler.");
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ResponseEncodeHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("response-encode"), null);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AllowedContentEncodings encodings = this.contentEncodingRepository.getContentEncodings(exchange);
        if (encodings == null || !exchange.isResponseChannelAvailable()) {
            Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
        } else {
            if (encodings.isNoEncodingsAllowed()) {
                this.setExchangeStatus(exchange, NO_ENCODING_HANDLER, new Object[0]);
                return;
            }
            exchange.addResponseWrapper((ConduitWrapper)encodings);
            exchange.putAttachment(AllowedContentEncodings.ATTACHMENT_KEY, (Object)encodings);
            Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
        }
    }
}

