/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.router;

import com.networknt.config.Config;
import com.networknt.graphql.common.GraphqlUtil;
import com.networknt.graphql.router.SchemaProvider;
import com.networknt.status.Status;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlPostHandler
implements HttpHandler {
    static final String STATUS_GRAPHQL_MISSING_QUERY = "ERR11502";
    static final Logger logger = LoggerFactory.getLogger(GraphqlPostHandler.class);
    static GraphQLSchema schema = null;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map requestParameters = (Map)exchange.getAttachment(GraphqlUtil.GRAPHQL_PARAMS);
        if (logger.isDebugEnabled()) {
            logger.debug("requestParameters: " + requestParameters);
        }
        GraphQL graphQL = new GraphQL(schema);
        String query = (String)requestParameters.get("query");
        if (query == null) {
            Status status = new Status(STATUS_GRAPHQL_MISSING_QUERY, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        HashMap variables = (HashMap)requestParameters.get("variables");
        if (variables == null) {
            variables = new HashMap();
        }
        String operationName = (String)requestParameters.get("operationName");
        ExecutionResult executionResult = graphQL.execute(query, operationName, (Object)exchange, variables);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (executionResult.getErrors().size() > 0) {
            result.put("errors", executionResult.getErrors());
            logger.error("Errors: {}", (Object)executionResult.getErrors());
        } else {
            result.put("data", executionResult.getData());
        }
        exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(result));
    }

    static {
        ServiceLoader<SchemaProvider> schemaLoaders = ServiceLoader.load(SchemaProvider.class);
        for (SchemaProvider provider : schemaLoaders) {
            if (provider.getSchema() == null) continue;
            schema = provider.getSchema();
            break;
        }
        if (schema == null) {
            logger.error("Unable to load GraphQL schema - no SchemaProvider implementation available in the classpath");
        }
    }
}

