/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.router.handlers;

import com.networknt.config.Config;
import com.networknt.graphql.router.SchemaProvider;
import com.networknt.service.SingletonServiceFactory;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlOptionsHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlOptionsHandler.class);
    static GraphQLSchema schema = null;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args(includeDeprecated: true) {\n          ...InputValue\n        }\n        isRepeatable\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args(includeDeprecated: true) {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields(includeDeprecated: true) {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n    isDeprecated\n    deprecationReason\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build();
        ExecutionResult executionResult = graphQL.execute(executionInput);
        result.put("data", executionResult.getData());
        httpServerExchange.setStatusCode(200);
        httpServerExchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(result));
    }

    static {
        SchemaProvider schemaProvider = (SchemaProvider)SingletonServiceFactory.getBean(SchemaProvider.class);
        if (schemaProvider != null) {
            schema = schemaProvider.getSchema();
        }
        if (schema == null) {
            logger.error("Unable to load GraphQL schema - no SchemaProvider implementation in service.yml");
            throw new RuntimeException("Unable to load GraphQL schema - no SchemaProvider implementation in service.yml");
        }
    }
}

