/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.router.handlers;

import com.networknt.config.Config;
import com.networknt.graphql.common.GraphqlUtil;
import com.networknt.graphql.common.InstrumentationLoader;
import com.networknt.graphql.router.ExecutionStrategyProvider;
import com.networknt.graphql.router.GraphqlCustomHandler;
import com.networknt.graphql.router.SchemaProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlPostHandler
implements HttpHandler {
    private static final String STATUS_GRAPHQL_MISSING_QUERY = "ERR11502";
    private static final Logger logger;
    static GraphQLSchema schema;
    static ExecutionStrategy queryExecutionStrategy;
    static ExecutionStrategy mutationExecutionStrategy;
    static ExecutionStrategy subscriptionExecutionStrategy;
    static GraphqlCustomHandler customHandler;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map requestParameters = (Map)exchange.getAttachment(GraphqlUtil.GRAPHQL_PARAMS);
        if (logger.isDebugEnabled()) {
            logger.debug("requestParameters: " + requestParameters);
        }
        GraphQL graphQL = this.getGraphql();
        String query = (String)requestParameters.get("query");
        if (query == null) {
            Status status = new Status(STATUS_GRAPHQL_MISSING_QUERY, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(status.toString());
            logger.error(status.toString());
            return;
        }
        HashMap variables = (HashMap)requestParameters.get("variables");
        if (variables == null) {
            variables = new HashMap();
        }
        String operationName = (String)requestParameters.get("operationName");
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context((Object)exchange).root((Object)exchange).variables(variables).build();
        ExecutionResult executionResult = graphQL.execute(executionInput);
        if (customHandler != null) {
            customHandler.handleResponse(exchange, executionResult);
        } else {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (executionResult.getErrors().size() > 0) {
                result.put("errors", executionResult.getErrors());
                logger.error("Errors: {}", (Object)executionResult.getErrors());
            } else {
                result.put("data", executionResult.getData());
            }
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.setStatusCode(200);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(result));
        }
    }

    private GraphQL getGraphql() {
        GraphQL.Builder graphql = GraphQL.newGraphQL((GraphQLSchema)schema);
        if (InstrumentationLoader.graphqlInstrumentation != null) {
            graphql = graphql.instrumentation(InstrumentationLoader.graphqlInstrumentation);
        }
        if (queryExecutionStrategy != null) {
            graphql.queryExecutionStrategy(queryExecutionStrategy);
        }
        if (mutationExecutionStrategy != null) {
            graphql.mutationExecutionStrategy(mutationExecutionStrategy);
        }
        if (subscriptionExecutionStrategy != null) {
            graphql.subscriptionExecutionStrategy(subscriptionExecutionStrategy);
        }
        return graphql.build();
    }

    static {
        ExecutionStrategyProvider executionStrategyProvider;
        logger = LoggerFactory.getLogger(GraphqlPostHandler.class);
        schema = null;
        queryExecutionStrategy = null;
        mutationExecutionStrategy = null;
        subscriptionExecutionStrategy = null;
        customHandler = null;
        SchemaProvider schemaProvider = (SchemaProvider)SingletonServiceFactory.getBean(SchemaProvider.class);
        if (schemaProvider != null) {
            schema = schemaProvider.getSchema();
        }
        if (schema == null) {
            logger.error("Unable to load GraphQL schema - no SchemaProvider implementation in service.yml");
            throw new RuntimeException("Unable to load GraphQL schema - no SchemaProvider implementation in service.yml");
        }
        GraphqlCustomHandler handler = (GraphqlCustomHandler)SingletonServiceFactory.getBean(GraphqlCustomHandler.class);
        if (handler != null) {
            customHandler = handler;
        }
        if ((executionStrategyProvider = (ExecutionStrategyProvider)SingletonServiceFactory.getBean(ExecutionStrategyProvider.class)) != null) {
            queryExecutionStrategy = executionStrategyProvider.getQueryExecutionStrategy();
            mutationExecutionStrategy = executionStrategyProvider.getMutationExecutionStrategy();
            subscriptionExecutionStrategy = executionStrategyProvider.getSubscriptionExecutionStrategy();
        }
    }
}

