/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.router.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.config.Config;
import com.networknt.graphql.common.InstrumentationLoader;
import com.networknt.graphql.router.handlers.GraphqlPostHandler;
import com.networknt.graphql.router.models.QueryParameters;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import graphql.execution.reactive.CompletionStageMappingPublisher;
import graphql.schema.GraphQLSchema;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;

public class GraphqlSubscriptionHandler
implements WebSocketConnectionCallback {
    private Logger logger = LoggerFactory.getLogger(GraphqlSubscriptionHandler.class);

    public void onConnect(WebSocketHttpExchange webSocketHttpExchange, WebSocketChannel webSocketChannel) {
        webSocketChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onError(WebSocketChannel channel, Throwable error) {
                if (GraphqlSubscriptionHandler.this.logger.isDebugEnabled()) {
                    GraphqlSubscriptionHandler.this.logger.debug("Websocket connection error.");
                }
                super.onError(channel, error);
            }

            protected void onClose(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
                if (GraphqlSubscriptionHandler.this.logger.isDebugEnabled()) {
                    GraphqlSubscriptionHandler.this.logger.debug("Websocket connection close.");
                }
                super.onClose(webSocketChannel, channel);
            }

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                Map inputData;
                String requestType;
                String messageData = message.getData();
                if (GraphqlSubscriptionHandler.this.logger.isDebugEnabled()) {
                    GraphqlSubscriptionHandler.this.logger.debug("Message = " + messageData);
                }
                if ("connection_init".equals(requestType = (String)(inputData = (Map)Config.getInstance().getMapper().readValue(messageData, Map.class)).get("type"))) {
                    GraphqlSubscriptionHandler.this.sendInitSuccess(channel);
                } else if ("start".equals(requestType)) {
                    String operationId = (String)inputData.get("id");
                    ExecutionResult executionResult = GraphqlSubscriptionHandler.this.getExecutionResult(inputData);
                    if (executionResult.getErrors() != null && executionResult.getErrors().size() > 0) {
                        GraphqlSubscriptionHandler.this.sendDataResponse(channel, executionResult, operationId);
                    } else {
                        GraphqlSubscriptionHandler.this.subscribeToResults(executionResult, channel, operationId);
                    }
                } else if ("stop".equals(requestType)) {
                    GraphqlSubscriptionHandler.this.logger.warn("GQL_STOP not yet implemented.");
                } else {
                    GraphqlSubscriptionHandler.this.logger.error("Request type not recognized as supported protocol: " + requestType + " see https://github.com/apollographql/subscriptions-transport-ws/blob/master/PROTOCOL.md");
                }
            }
        });
        webSocketChannel.resumeReceives();
    }

    private ExecutionResult getExecutionResult(Map inputData) {
        QueryParameters parameters = QueryParameters.from(inputData);
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(parameters.getQuery()).variables(parameters.getVariables()).build();
        return GraphQL.newGraphQL((GraphQLSchema)GraphqlPostHandler.schema).instrumentation(this.getInstrumentation()).build().execute(executionInput);
    }

    private void sendDataResponse(WebSocketChannel channel, ExecutionResult executionResult, String operationId) {
        HashMap<String, Object> nextPayload = new HashMap<String, Object>();
        if (executionResult.getData() != null) {
            nextPayload.put("data", executionResult.getData());
        }
        if (executionResult.getErrors() != null && executionResult.getErrors().size() > 0) {
            nextPayload.put("errors", executionResult.getErrors());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", operationId);
        result.put("type", "data");
        result.put("payload", nextPayload);
        try {
            WebSockets.sendText((String)Config.getInstance().getMapper().writeValueAsString(result), (WebSocketChannel)channel, null);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error while processing data response", (Throwable)e);
        }
    }

    private void subscribeToResults(ExecutionResult executionResult, final WebSocketChannel channel, final String operationId) {
        CompletionStageMappingPublisher mappingPublisher = (CompletionStageMappingPublisher)executionResult.getData();
        mappingPublisher.subscribe((Subscriber)new Subscriber<ExecutionResult>(){
            private final AtomicReference<Subscription> subscriptionRef = new AtomicReference();

            public void onSubscribe(Subscription subscription) {
                this.subscriptionRef.set(subscription);
                subscription.request(1L);
            }

            public void onNext(ExecutionResult nextExecutionResult) {
                GraphqlSubscriptionHandler.this.sendDataResponse(channel, nextExecutionResult, operationId);
                this.subscriptionRef.get().request(1L);
            }

            public void onError(Throwable throwable) {
                GraphqlSubscriptionHandler.this.logger.info("Subscription onError", throwable);
                this.subscriptionRef.get().cancel();
            }

            public void onComplete() {
                GraphqlSubscriptionHandler.this.logger.info("Subscription onComplete");
                this.subscriptionRef.get().cancel();
            }
        });
    }

    private void sendInitSuccess(WebSocketChannel channel) throws JsonProcessingException {
        HashMap<String, String> outputData = new HashMap<String, String>();
        outputData.put("type", "connection_ack");
        WebSockets.sendText((String)Config.getInstance().getMapper().writeValueAsString(outputData), (WebSocketChannel)channel, null);
    }

    private Instrumentation getInstrumentation() {
        if (InstrumentationLoader.graphqlSubscriptionInstrumentation == null) {
            return new ChainedInstrumentation(Collections.singletonList(new TracingInstrumentation()));
        }
        return InstrumentationLoader.graphqlSubscriptionInstrumentation;
    }
}

