/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.session.jdbc;

import com.networknt.session.MapSession;
import com.networknt.session.Session;
import com.networknt.session.SessionRepository;
import com.networknt.session.jdbc.serializer.SerializationFailedException;
import com.networknt.session.jdbc.serializer.ValueBytesConverter;
import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSessionRepository
implements SessionRepository<JdbcSession> {
    private static final String CREATE_SESSION_QUERY = "INSERT INTO light_session(SESSION_ID, CREATION_TIME, LAST_ACCESS_TIME, MAX_INACTIVE_INTERVAL, EXPIRY_TIME, PRINCIPAL_NAME) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO light_session_attributes(SESSION_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?)";
    private static final String GET_SESSION_QUERY = "SELECT S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM light_session S LEFT OUTER JOIN light_session_attributes SA ON S.SESSION_ID = SA.SESSION_ID WHERE S.SESSION_ID = ?";
    private static final String GET_ALL_SESSION_QUERY = "SELECT S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM light_session S LEFT OUTER JOIN light_session_attributes SA ON S.SESSION_ID = SA.SESSION_ID WHERE EXPIRY_TIME > ?";
    private static final String UPDATE_SESSION_QUERY = "UPDATE light_session SET SESSION_ID = ?, LAST_ACCESS_TIME = ?, MAX_INACTIVE_INTERVAL = ?, EXPIRY_TIME = ?, PRINCIPAL_NAME = ? WHERE SESSION_ID = ?";
    private static final String UPDATE_SESSION_ACCESS_TIME_QUERY = "UPDATE light_session SET  LAST_ACCESS_TIME = ? WHERE SESSION_ID = ?";
    private static final String UPDATE_SESSION_ATTRIBUTE_QUERY = "UPDATE light_session_attributes SET ATTRIBUTE_BYTES = ? WHERE SESSION_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_ATTRIBUTE_QUERY = "DELETE FROM light_session_attributes WHERE SESSION_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_QUERY = "DELETE FROM light_session WHERE SESSION_ID = ?";
    private static final String LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT S.PRIMARY_ID, S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM light_session S LEFT OUTER JOIN light_session_attributes SA ON S.PRIMARY_ID = SA.SESSION_PRIMARY_ID WHERE S.PRINCIPAL_NAME = ?";
    private static final String DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY = "DELETE FROM light_session WHERE EXPIRY_TIME < ?";
    private static final Logger logger = LoggerFactory.getLogger(JdbcSessionRepository.class);
    private String createSessionQuery;
    private String createSessionAttributeQuery;
    private String getSessionQuery;
    private String getAllSessionQuery;
    private String updateSessionQuery;
    private String updateSessionAttributeQuery;
    private String deleteSessionAttributeQuery;
    private String deleteSessionQuery;
    private String listSessionsByPrincipalNameQuery;
    private String deleteSessionsByExpiryTimeQuery;
    private Integer defaultMaxInactiveInterval = 1800;
    private volatile long startTime;
    private ValueBytesConverter converter = new ValueBytesConverter();
    private DataSource dataSource;

    public JdbcSessionRepository(DataSource dataSource) {
        this.dataSource = dataSource;
        this.prepareQueries();
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public JdbcSession createSession() {
        JdbcSession session = new JdbcSession();
        if (this.defaultMaxInactiveInterval != null) {
            session.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        }
        this.save(session);
        return session;
    }

    public Map<String, Session> getSessions() {
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(this.getAllSessionQuery);
            stmt.setLong(1, System.currentTimeMillis());
            ResultSet rs = stmt.executeQuery();
            List<JdbcSession> sessions = this.extractData(rs);
            if (!sessions.isEmpty()) {
                for (JdbcSession session : sessions) {
                    sessionMap.put(session.getId(), session);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SqlException:", (Throwable)e);
        }
        return sessionMap;
    }

    public void save(JdbcSession session) {
        if (session.isNew()) {
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(this.createSessionQuery);
                stmt.setString(1, session.getId());
                stmt.setLong(2, session.getCreationTime());
                stmt.setLong(3, session.getLastAccessedTime());
                stmt.setInt(4, session.getMaxInactiveInterval());
                stmt.setLong(5, session.getExpiryTime());
                stmt.setString(6, session.getPrincipalName());
                int count = stmt.executeUpdate();
                if (!session.getAttributeNames().isEmpty()) {
                    ArrayList<String> attributeNames = new ArrayList<String>(session.getAttributeNames());
                    try (PreparedStatement psAtt = connection.prepareStatement(this.createSessionAttributeQuery);){
                        for (String attributeName : attributeNames) {
                            psAtt.setString(1, session.getId());
                            psAtt.setString(2, attributeName);
                            this.serialize(psAtt, 3, session.getAttribute(attributeName));
                            psAtt.addBatch();
                        }
                        psAtt.executeBatch();
                    }
                }
                connection.commit();
                if (count != 1) {
                    logger.error("Failed to insert session: {}", (Object)session.getId());
                }
            }
            catch (SQLException e) {
                logger.error("SqlException:", (Throwable)e);
            }
        } else {
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(this.updateSessionQuery);
                stmt.setString(1, session.getId());
                stmt.setLong(2, session.getLastAccessedTime());
                stmt.setInt(3, session.getMaxInactiveInterval());
                stmt.setLong(4, session.getExpiryTime());
                stmt.setString(5, session.getPrincipalName());
                stmt.setString(6, session.getId());
                int count = stmt.executeUpdate();
                Map<String, Object> delta = session.getDelta();
                if (!delta.isEmpty()) {
                    for (Map.Entry<String, Object> entry : delta.entrySet()) {
                        if (entry.getValue() == null) {
                            PreparedStatement psAtt = connection.prepareStatement(this.deleteSessionAttributeQuery);
                            Throwable attributeName = null;
                            try {
                                psAtt.setString(1, session.getId());
                                psAtt.setString(2, entry.getKey());
                                psAtt.executeUpdate();
                                continue;
                            }
                            catch (Throwable throwable) {
                                attributeName = throwable;
                                throw throwable;
                            }
                            finally {
                                if (psAtt == null) continue;
                                if (attributeName != null) {
                                    try {
                                        psAtt.close();
                                    }
                                    catch (Throwable throwable) {
                                        attributeName.addSuppressed(throwable);
                                    }
                                    continue;
                                }
                                psAtt.close();
                                continue;
                            }
                        }
                        int updatedCount = 0;
                        try (PreparedStatement psAtt = connection.prepareStatement(this.updateSessionAttributeQuery);){
                            this.serialize(psAtt, 1, entry.getValue());
                            psAtt.setString(2, session.getId());
                            psAtt.setString(3, entry.getKey());
                            updatedCount = psAtt.executeUpdate();
                        }
                        if (updatedCount != 0) continue;
                        psAtt = connection.prepareStatement(this.createSessionAttributeQuery);
                        var11_30 = null;
                        try {
                            psAtt.setString(1, session.getId());
                            psAtt.setString(2, entry.getKey());
                            this.serialize(psAtt, 3, entry.getValue());
                            psAtt.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            var11_30 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (psAtt == null) continue;
                            if (var11_30 != null) {
                                try {
                                    psAtt.close();
                                }
                                catch (Throwable throwable) {
                                    var11_30.addSuppressed(throwable);
                                }
                                continue;
                            }
                            psAtt.close();
                        }
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                logger.error("SqlException:", (Throwable)e);
            }
        }
        session.clearChangeFlags();
    }

    public JdbcSession findById(String id) {
        JdbcSession session = null;
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(this.getSessionQuery);
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            List<JdbcSession> sessions = this.extractData(rs);
            if (!sessions.isEmpty()) {
                session = sessions.get(0);
            }
        }
        catch (SQLException e) {
            logger.error("SqlException:", (Throwable)e);
        }
        if (session != null) {
            if (session.isExpired()) {
                this.deleteById(id);
            } else {
                return session;
            }
        }
        return null;
    }

    public void deleteById(String id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement psAtt = connection.prepareStatement(this.deleteSessionQuery);){
            psAtt.setString(1, id);
            psAtt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("SqlException:", (Throwable)e);
        }
    }

    public void cleanUpExpiredSessions() {
        int deletedCount = 0;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement psAtt = connection.prepareStatement(this.deleteSessionsByExpiryTimeQuery);){
            psAtt.setLong(1, System.currentTimeMillis());
            psAtt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("SqlException:", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cleaned up " + deletedCount + " expired sessions");
        }
    }

    public void updateSessionLastAccessTime(String id) {
        boolean count = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement psAtt = connection.prepareStatement(UPDATE_SESSION_ACCESS_TIME_QUERY);){
            psAtt.setLong(1, System.currentTimeMillis());
            psAtt.setString(2, id);
            psAtt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("SqlException:", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("session access change " + id + " to current time");
        }
    }

    private String getQuery(String base) {
        return base;
    }

    private void prepareQueries() {
        this.createSessionQuery = this.getQuery(CREATE_SESSION_QUERY);
        this.createSessionAttributeQuery = this.getQuery(CREATE_SESSION_ATTRIBUTE_QUERY);
        this.getSessionQuery = this.getQuery(GET_SESSION_QUERY);
        this.getAllSessionQuery = this.getQuery(GET_ALL_SESSION_QUERY);
        this.updateSessionQuery = this.getQuery(UPDATE_SESSION_QUERY);
        this.updateSessionAttributeQuery = this.getQuery(UPDATE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionAttributeQuery = this.getQuery(DELETE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionQuery = this.getQuery(DELETE_SESSION_QUERY);
        this.listSessionsByPrincipalNameQuery = this.getQuery(LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY);
        this.deleteSessionsByExpiryTimeQuery = this.getQuery(DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY);
    }

    private void serialize(PreparedStatement ps, int paramIndex, Object attributeValue) throws SQLException {
        try {
            byte[] bytes = this.converter.serializer(attributeValue);
            if (bytes != null) {
                ps.setBlob(paramIndex, new ByteArrayInputStream(bytes), bytes.length);
            } else {
                ps.setBlob(paramIndex, (Blob)null);
            }
        }
        catch (SerializationFailedException e) {
            throw new SQLException("Failed to serialize object ", e);
        }
    }

    private Object deserialize(ResultSet rs, String columnName) throws SQLException {
        byte[] result = rs.getBytes(columnName);
        try {
            return this.converter.deserialize(result);
        }
        catch (SerializationFailedException e) {
            throw new SQLException("Failed to serialize object ", e);
        }
    }

    public List<JdbcSession> extractData(ResultSet rs) throws SQLException {
        ArrayList<JdbcSession> sessions = new ArrayList<JdbcSession>();
        while (rs.next()) {
            JdbcSession session;
            String id = rs.getString("SESSION_ID");
            if (sessions.size() > 0 && this.getLast(sessions).getId().equals(id)) {
                session = this.getLast(sessions);
            } else {
                MapSession delegate = new MapSession(rs.getString("SESSION_ID"));
                delegate.setMaxInactiveInterval(rs.getInt("MAX_INACTIVE_INTERVAL"));
                delegate.setCreationTime(rs.getLong("CREATION_TIME"));
                delegate.setLastAccessedTime(rs.getLong("LAST_ACCESS_TIME"));
                session = new JdbcSession(delegate);
            }
            String attributeName = rs.getString("ATTRIBUTE_NAME");
            if (attributeName != null) {
                session.setAttribute(attributeName, this.deserialize(rs, "ATTRIBUTE_BYTES"));
            }
            sessions.add(session);
        }
        return sessions;
    }

    private JdbcSession getLast(List<JdbcSession> sessions) {
        return sessions.get(sessions.size() - 1);
    }

    final class JdbcSession
    implements Session {
        private final MapSession delegate;
        private boolean isNew;
        private boolean changed;
        private Map<String, Object> delta = new HashMap<String, Object>();

        JdbcSession() {
            this.delegate = new MapSession();
            this.isNew = true;
        }

        JdbcSession(MapSession delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        boolean isNew() {
            return this.isNew;
        }

        boolean isChanged() {
            return this.changed;
        }

        Map<String, Object> getDelta() {
            return this.delta;
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.changed = false;
            this.delta.clear();
        }

        public long getExpiryTime() {
            return this.getLastAccessedTime() + (long)this.getMaxInactiveInterval();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String changeSessionId() {
            this.changed = true;
            return this.delegate.changeSessionId();
        }

        public Object getAttribute(String attributeName) {
            return this.delegate.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public Object setAttribute(String attributeName, Object attributeValue) {
            this.delegate.setAttribute(attributeName, attributeValue);
            this.delta.put(attributeName, attributeValue);
            this.changed = true;
            JdbcSessionRepository.this.save(this);
            return attributeValue;
        }

        public Object removeAttribute(String attributeName) {
            Object object = this.delegate.removeAttribute(attributeName);
            this.delta.put(attributeName, null);
            this.changed = true;
            JdbcSessionRepository.this.save(this);
            return object;
        }

        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.changed = true;
            JdbcSessionRepository.this.updateSessionLastAccessTime(this.getId());
        }

        public long getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(int interval) {
            this.delegate.setMaxInactiveInterval(interval);
            this.changed = true;
        }

        public int getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public String getPrincipalName() {
            return "light-user";
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }
    }
}

