/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.session.jdbc;

import com.networknt.session.Session;
import com.networknt.session.SessionManager;
import com.networknt.session.SessionRepository;
import com.networknt.session.jdbc.JdbcSessionRepository;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.util.AttachmentKey;
import java.util.Map;
import java.util.Objects;

public class JdbcSessionManager
implements SessionManager {
    private final AttachmentKey<JdbcSessionRepository.JdbcSession> NEW_SESSION = AttachmentKey.create(JdbcSessionRepository.JdbcSession.class);
    private SessionConfig sessionConfig;
    private SessionRepository sessionRepository;
    public static final String DEPLOY_NAME = "JDBC-SESSION";

    public JdbcSessionManager(SessionConfig sessionConfig, SessionRepository sessionRepository) {
        Objects.requireNonNull(sessionConfig);
        Objects.requireNonNull(sessionRepository);
        this.sessionConfig = sessionConfig;
        this.sessionRepository = sessionRepository;
    }

    public String getDeploymentName() {
        return DEPLOY_NAME;
    }

    public Session createSession(HttpServerExchange serverExchange) {
        JdbcSessionRepository.JdbcSession session = (JdbcSessionRepository.JdbcSession)this.sessionRepository.createSession();
        this.sessionConfig.setSessionId(serverExchange, session.getId());
        serverExchange.putAttachment(this.NEW_SESSION, (Object)session);
        return session;
    }

    public Map<String, Session> getSessions() {
        return null;
    }

    public Session getSession(HttpServerExchange serverExchange) {
        JdbcSessionRepository.JdbcSession newSession;
        if (serverExchange != null && (newSession = (JdbcSessionRepository.JdbcSession)serverExchange.getAttachment(this.NEW_SESSION)) != null) {
            return newSession;
        }
        String sessionId = this.sessionConfig.findSessionId(serverExchange);
        Session session = this.getSession(sessionId);
        if (session == null) {
            this.sessionConfig.clearSession(serverExchange, sessionId);
        }
        return session;
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        Session session = this.sessionRepository.findById(sessionId);
        if (session != null && !session.isExpired()) {
            session.setLastAccessedTime(System.currentTimeMillis());
            return session;
        }
        return null;
    }

    public Session removeSession(HttpServerExchange serverExchange) {
        if (serverExchange != null) {
            String sessionId = this.sessionConfig.findSessionId(serverExchange);
            Session oldSession = (Session)serverExchange.removeAttachment(this.NEW_SESSION);
            this.removeSession(sessionId);
            return oldSession;
        }
        return null;
    }

    public void removeSession(String sessionId) {
        this.sessionRepository.deleteById(sessionId);
    }
}

