/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.session.jdbc.serializer;

import com.networknt.session.jdbc.serializer.DefaultDeserializer;
import com.networknt.session.jdbc.serializer.DefaultSerializer;
import com.networknt.session.jdbc.serializer.Deserializer;
import com.networknt.session.jdbc.serializer.SerializationFailedException;
import com.networknt.session.jdbc.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ValueBytesConverter {
    private final Deserializer<Object> deserializer = new DefaultDeserializer();
    private final Serializer<Object> serializer = new DefaultSerializer();

    public Object deserialize(byte[] source) throws SerializationFailedException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(source);
        try {
            return this.deserializer.deserialize(byteStream);
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to deserialize payload. Is the byte array a result of corresponding serialization for " + this.deserializer.getClass().getSimpleName() + "?", ex);
        }
    }

    public byte[] serializer(Object source) throws SerializationFailedException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(1024);
        try {
            this.serializer.serialize(source, byteStream);
            return byteStream.toByteArray();
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to serialize object using " + this.serializer.getClass().getSimpleName(), ex);
        }
    }
}

