/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.logging.model;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;

@ConfigSchema(configKey="logging", configName="logging", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class LoggerConfig {
    public static final String CONFIG_NAME = "logging";
    private static final String ENABLED = "enabled";
    private static final String LOG_START = "logStart";
    private static final String DOWNSTREAM_ENABLED = "downstreamEnabled";
    private static final String DOWNSTREAM_HOST = "downstreamHost";
    private static final String DOWNSTREAM_FRAMEWORK = "downstreamFramework";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", defaultValue="true", externalized=true, description="Indicate if the logging info is enabled or not.")
    boolean enabled;
    @IntegerField(configFieldName="logStart", externalizedKeyName="logStart", defaultValue="600000", externalized=true, description="Indicate the default time period backward in millisecond for log content retrieve.\nDefault is an hour which indicate system will retrieve one hour log by default")
    long logStart;
    @BooleanField(configFieldName="downstreamEnabled", externalizedKeyName="downstreamEnabled", externalized=true, description="if the logger access needs to invoke down streams API. It is false by default.")
    boolean downstreamEnabled;
    @StringField(configFieldName="downstreamHost", externalizedKeyName="downstreamHost", externalized=true, defaultValue="http://localhost:8081", description="down stream API host. http://localhost is the default when used with http-sidecar and kafka-sidecar.")
    String downstreamHost;
    @StringField(configFieldName="downstreamFramework", externalizedKeyName="downstreamFramework", externalized=true, defaultValue="Light4j", description="down stream API framework that has the admin endpoints. Light4j, SpringBoot, Quarkus, Micronaut, Helidon, etc. If the adm endpoints are different between\ndifferent versions, you can use the framework plus version as the identifier. For example, Light4j-1.6.0, SpringBoot-2.4.0, etc.")
    String downstreamFramework;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private LoggerConfig() {
        this(CONFIG_NAME);
    }

    private LoggerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static LoggerConfig load() {
        return new LoggerConfig();
    }

    public static LoggerConfig load(String configName) {
        return new LoggerConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue((String)ENABLED, (Object)object);
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_ENABLED)) != null) {
            this.downstreamEnabled = Config.loadBooleanValue((String)DOWNSTREAM_ENABLED, (Object)object);
        }
        if ((object = this.getMappedConfig().get(LOG_START)) != null) {
            this.logStart = Config.loadLongValue((String)LOG_START, (Object)object);
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_HOST)) != null) {
            this.downstreamHost = (String)object;
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_FRAMEWORK)) != null) {
            this.downstreamFramework = (String)object;
        }
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getLogStart() {
        return this.logStart;
    }

    public void setLogStart(long logStart) {
        this.logStart = logStart;
    }

    public boolean isDownstreamEnabled() {
        return this.downstreamEnabled;
    }

    public void setDownstreamEnabled(boolean downstreamEnabled) {
        this.downstreamEnabled = downstreamEnabled;
    }

    public String getDownstreamHost() {
        return this.downstreamHost;
    }

    public void setDownstreamHost(String downstreamHost) {
        this.downstreamHost = downstreamHost;
    }

    public String getDownstreamFramework() {
        return this.downstreamFramework;
    }

    public void setDownstreamFramework(String downstreamFramework) {
        this.downstreamFramework = downstreamFramework;
    }
}

