/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.networknt.auth.MsalExchangeConfig;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.RefreshTokenRequest;
import com.networknt.client.oauth.TokenExchangeRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Result;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.UuidUtil;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.util.Headers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsalTokenExchangeHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(MsalTokenExchangeHandler.class);
    private static final String JWT_BEARER_TOKEN_MISSING = "ERR11000";
    private static final String TOKEN_EXCHANGE_FAILED = "ERR11001";
    private static final String INVALID_AUTH_TOKEN = "ERR10000";
    private static final String CSRF_HEADER_MISSING = "ERR10036";
    private static final String CSRF_TOKEN_MISSING_IN_JWT = "ERR10038";
    private static final String HEADER_CSRF_JWT_CSRF_NOT_MATCH = "ERR10039";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String REFRESH_TOKEN = "refreshToken";
    private static final String USER_TYPE = "userType";
    private static final String USER_ID = "userId";
    protected static final String SCOPES = "scopes";
    private static final String SCOPE = "scope";
    private static final String SCP = "scp";
    private static final String ROLE = "role";
    public static MsalExchangeConfig config = (MsalExchangeConfig)Config.getInstance().getJsonObjectConfig("msal-exchange", MsalExchangeConfig.class);
    static SecurityConfig securityConfig = SecurityConfig.load();
    static SecurityConfig msalSecurityConfig;
    static JwtVerifier internalJwtVerifier;
    static JwtVerifier msalJwtVerifier;
    private volatile HttpHandler next;

    public MsalTokenExchangeHandler() {
        logger.info("MsalTokenExchangeHandler is constructed.");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRelativePath().equals(config.getExchangePath())) {
            String authHeader;
            if (logger.isTraceEnabled()) {
                logger.trace("MsalTokenExchangeHandler exchange is called.");
            }
            if ((authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION)) == null || !authHeader.startsWith("Bearer ")) {
                this.setExchangeStatus(exchange, JWT_BEARER_TOKEN_MISSING, new Object[0]);
                return;
            }
            String microsoftToken = authHeader.substring(7);
            if (msalJwtVerifier == null) {
                throw new Exception("MsalJwtVerifier is not initialized.");
            }
            try {
                String reqPath = exchange.getRequestPath();
                msalJwtVerifier.verifyJwt(microsoftToken, msalSecurityConfig.isIgnoreJwtExpiry(), true, null, reqPath, null);
            }
            catch (InvalidJwtException e) {
                logger.error("Microsoft token validation failed.", (Throwable)e);
                this.setExchangeStatus(exchange, INVALID_AUTH_TOKEN, new Object[]{e.getMessage()});
                return;
            }
            String csrf = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            TokenExchangeRequest request = new TokenExchangeRequest();
            request.setSubjectToken(microsoftToken);
            request.setSubjectTokenType("urn:ietf:params:oauth:token-type:jwt");
            request.setCsrf(csrf);
            Result result = OauthHelper.getTokenFromTokenExchangeResult((TokenExchangeRequest)request);
            if (result.isFailure()) {
                logger.error("Token exchange failed with status: {}", (Object)result.getError());
                this.setExchangeStatus(exchange, TOKEN_EXCHANGE_FAILED, new Object[]{result.getError().getDescription()});
                return;
            }
            List<String> scopes = this.setCookies(exchange, (TokenResponse)result.getResult(), csrf);
            if (logger.isTraceEnabled()) {
                logger.trace("scopes = {}", scopes);
            }
            exchange.setStatusCode(200);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            HashMap<String, List<String>> rs = new HashMap<String, List<String>>();
            rs.put(SCOPES, scopes);
            exchange.getResponseSender().send(JsonMapper.toJson(rs));
        } else if (exchange.getRelativePath().equals(config.getLogoutPath())) {
            if (logger.isTraceEnabled()) {
                logger.trace("MsalTokenExchangeHandler logout is called.");
            }
            this.removeCookies(exchange);
            exchange.endExchange();
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("MsalTokenExchangeHandler is called for subsequent request.");
            }
            String jwt = null;
            Cookie cookie = exchange.getRequestCookie(ACCESS_TOKEN);
            if (cookie != null) {
                jwt = cookie.getValue();
                JwtClaims claims = internalJwtVerifier.verifyJwt(jwt, securityConfig.isIgnoreJwtExpiry(), true);
                String jwtCsrf = claims.getStringClaimValue("csrf");
                String headerCsrf = exchange.getRequestHeaders().getFirst(HttpStringConstants.CSRF_TOKEN);
                if (headerCsrf == null || headerCsrf.trim().length() == 0) {
                    this.setExchangeStatus(exchange, CSRF_HEADER_MISSING, new Object[0]);
                    return;
                }
                if (jwtCsrf == null || jwtCsrf.trim().length() == 0) {
                    this.setExchangeStatus(exchange, CSRF_TOKEN_MISSING_IN_JWT, new Object[0]);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("headerCsrf = " + headerCsrf + " jwtCsrf = " + jwtCsrf);
                }
                if (!headerCsrf.equals(jwtCsrf)) {
                    this.setExchangeStatus(exchange, HEADER_CSRF_JWT_CSRF_NOT_MATCH, new Object[]{headerCsrf, jwtCsrf});
                    return;
                }
                if (claims.getExpirationTime().getValueInMillis() - System.currentTimeMillis() < 90000L) {
                    jwt = this.renewToken(exchange, exchange.getRequestCookie(REFRESH_TOKEN));
                }
            } else {
                jwt = this.renewToken(exchange, exchange.getRequestCookie(REFRESH_TOKEN));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("jwt = " + jwt);
            }
            if (jwt != null) {
                exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + jwt);
            }
            if (!exchange.isComplete()) {
                Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            }
        }
    }

    private String renewToken(HttpServerExchange exchange, Cookie cookie) throws Exception {
        String refreshToken;
        String jwt = null;
        if (cookie != null && (refreshToken = cookie.getValue()) != null) {
            RefreshTokenRequest tokenRequest = new RefreshTokenRequest();
            String csrf = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            tokenRequest.setCsrf(csrf);
            tokenRequest.setRefreshToken(refreshToken);
            Result result = OauthHelper.getTokenResult((TokenRequest)tokenRequest);
            if (result.isSuccess()) {
                TokenResponse response = (TokenResponse)result.getResult();
                this.setCookies(exchange, response, csrf);
                jwt = response.getAccessToken();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get the access token from refresh token with error: {}", (Object)result.getError());
                }
                this.removeCookies(exchange);
                exchange.endExchange();
            }
        }
        return jwt;
    }

    private void removeCookies(HttpServerExchange exchange) {
        Cookie eidCookie;
        Cookie emailCookie;
        Cookie hostCookie;
        Cookie rolesCookie;
        Cookie userTypeCookie;
        Cookie userIdCookie;
        Cookie csrfCookie;
        Cookie refreshTokenCookie;
        Cookie accessTokenCookie = exchange.getRequestCookie(ACCESS_TOKEN);
        if (accessTokenCookie != null) {
            accessTokenCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(true).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(accessTokenCookie);
        }
        if ((refreshTokenCookie = exchange.getRequestCookie(REFRESH_TOKEN)) != null) {
            refreshTokenCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(true).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(refreshTokenCookie);
        }
        if ((csrfCookie = exchange.getRequestCookie("csrf")) != null) {
            csrfCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(true).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(csrfCookie);
        }
        if ((userIdCookie = exchange.getRequestCookie(USER_ID)) != null) {
            userIdCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(userIdCookie);
        }
        if ((userTypeCookie = exchange.getRequestCookie(USER_TYPE)) != null) {
            userTypeCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(userTypeCookie);
        }
        if ((rolesCookie = exchange.getRequestCookie("roles")) != null) {
            rolesCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(rolesCookie);
        }
        if ((hostCookie = exchange.getRequestCookie("host")) != null) {
            hostCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(hostCookie);
        }
        if ((emailCookie = exchange.getRequestCookie("email")) != null) {
            emailCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(emailCookie);
        }
        if ((eidCookie = exchange.getRequestCookie("eid")) != null) {
            eidCookie.setMaxAge(Integer.valueOf(0)).setValue("").setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setHttpOnly(false).setSecure(MsalTokenExchangeHandler.config.cookieSecure);
            exchange.setResponseCookie(eidCookie);
        }
    }

    protected List<String> setCookies(HttpServerExchange exchange, TokenResponse response, String csrf) throws Exception {
        String accessToken = response.getAccessToken();
        String refreshToken = response.getRefreshToken();
        String remember = response.getRemember();
        int expiresIn = (int)response.getExpiresIn();
        JwtClaims claims = null;
        String roles = null;
        String userType = null;
        String userId = null;
        String eid = null;
        String host = null;
        String email = null;
        List scopes = null;
        try {
            JwtContext context = internalJwtVerifier.parseJwt(accessToken);
            claims = context.getJwtClaims();
            roles = claims.getStringClaimValue(ROLE);
            if (roles == null) {
                roles = "user";
            }
            userType = claims.getStringClaimValue("user_type");
            userId = claims.getStringClaimValue("uid");
            eid = claims.getStringClaimValue("eid");
            scopes = claims.getStringListClaimValue(SCP);
            host = claims.getStringClaimValue("host");
            email = claims.getStringClaimValue("eml");
        }
        catch (InvalidJwtException e) {
            logger.error("Exception: ", (Throwable)e);
            this.setExchangeStatus(exchange, INVALID_AUTH_TOKEN, new Object[0]);
            return null;
        }
        exchange.setResponseCookie(new CookieImpl(ACCESS_TOKEN, accessToken).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(config.getCookiePath()).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(true).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        exchange.setResponseCookie(new CookieImpl(REFRESH_TOKEN, refreshToken).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(config.getCookiePath()).setMaxAge(Integer.valueOf(remember == null || remember.equals("N") ? config.getSessionTimeout() : config.getRememberMeTimeout())).setHttpOnly(true).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        exchange.setResponseCookie(new CookieImpl(USER_ID, userId).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        if (userType != null) {
            exchange.setResponseCookie(new CookieImpl(USER_TYPE, userType).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        }
        if (roles != null) {
            exchange.setResponseCookie(new CookieImpl("roles", roles).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        }
        if (host != null) {
            exchange.setResponseCookie(new CookieImpl("host", host).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        }
        if (email != null) {
            exchange.setResponseCookie(new CookieImpl("email", email).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        }
        if (eid != null) {
            exchange.setResponseCookie(new CookieImpl("eid", eid).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        }
        exchange.setResponseCookie(new CookieImpl("csrf", csrf).setDomain(MsalTokenExchangeHandler.config.cookieDomain).setPath(MsalTokenExchangeHandler.config.cookiePath).setMaxAge(Integer.valueOf(expiresIn)).setHttpOnly(false).setSameSiteMode(CookieSameSiteMode.NONE.toString()).setSecure(MsalTokenExchangeHandler.config.cookieSecure));
        return scopes;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)"msal-exchange", (String)MsalExchangeConfig.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("msal-exchange"), null);
    }

    static {
        internalJwtVerifier = new JwtVerifier(securityConfig);
        try {
            msalSecurityConfig = SecurityConfig.load((String)"security-msal");
            msalJwtVerifier = new JwtVerifier(msalSecurityConfig);
        }
        catch (ConfigException e) {
            logger.error("Failed to load msalJwt configuration from security.yml. Microsoft token validation will fail.", (Throwable)e);
            msalJwtVerifier = null;
        }
    }
}

