/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.networknt.client.Http2Client;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;

public class PortalClient {
    static final Logger logger = LoggerFactory.getLogger(PortalClient.class);
    static final String commandServiceId = "com.networknt.portal.hybrid.command-1.0.0";
    static final String queryServiceId = "com.networknt.portal.hybrid.query-1.0.0";
    static String tag = ServerConfig.getInstance().getEnvironment();
    static Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
    static Http2Client client = Http2Client.getInstance();
    static ClientConnection commandConnection;
    static ClientConnection queryConnection;
    static final String GENERIC_EXCEPTION = "ERR10014";

    public PortalClient() {
        String host = cluster.serviceToUrl("https", commandServiceId, tag, null);
        try {
            commandConnection = (ClientConnection)client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        host = cluster.serviceToUrl("https", queryServiceId, tag, null);
        try {
            queryConnection = (ClientConnection)client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }

    public static Result<String> callCommandWithToken(String command, String token) {
        Result result = null;
        try {
            if (commandConnection == null || !commandConnection.isOpen()) {
                String host = cluster.serviceToUrl("https", commandServiceId, tag, null);
                commandConnection = (ClientConnection)client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference reference = new AtomicReference();
            String message = "/portal/command?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            commandConnection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = ((ClientResponse)reference.get()).getResponseCode();
            String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                result = Failure.of((Status)status);
            } else {
                result = Success.of((Object)body);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
            result = Failure.of((Status)status);
        }
        return result;
    }

    public static Result<String> callQueryWithToken(String command, String token) {
        Result result = null;
        try {
            if (queryConnection == null || !queryConnection.isOpen()) {
                String host = cluster.serviceToUrl("https", queryServiceId, tag, null);
                queryConnection = (ClientConnection)client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference reference = new AtomicReference();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            queryConnection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = ((ClientResponse)reference.get()).getResponseCode();
            String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                result = Failure.of((Status)status);
            } else {
                result = Success.of((Object)body);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
            result = Failure.of((Status)status);
        }
        return result;
    }

    public static Result<String> createSocialUser(Map<String, Object> userMap, String token) {
        HashMap<String, Object> commandMap = new HashMap<String, Object>();
        commandMap.put("host", "lightapi.net");
        commandMap.put("service", "user");
        commandMap.put("action", "createSocialUser");
        commandMap.put("version", "0.1.0");
        commandMap.put("data", userMap);
        String command = JsonMapper.toJson(commandMap);
        if (logger.isTraceEnabled()) {
            logger.trace("command = " + command);
        }
        return PortalClient.callCommandWithToken(command, token);
    }

    public static Result<String> getUserByEmail(String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return PortalClient.callQueryWithToken(command, token);
    }
}

