/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.security.IJwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtVerifyHandler
implements MiddlewareHandler,
IJwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(JwtVerifyHandler.class);
    static final String OPENAPI_SECURITY_CONFIG = "openapi-security";
    static final String ENABLE_VERIFY_SCOPE = "enableVerifyScope";
    static final String ENABLE_VERIFY_JWT_SCOPE_TOKEN = "enableExtractScopeToken";
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static Map<String, Object> config = Config.getInstance().getJsonMapConfig("openapi-security");
    public static JwtVerifier jwtVerifier;
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        String jwt = JwtVerifier.getJwtFromAuthorization((String)authorization);
        if (jwt != null) {
            try {
                JwtClaims claims = jwtVerifier.verifyJwt(jwt, false, true);
                HashMap<String, String> auditInfo = (HashMap<String, String>)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
                if (auditInfo == null) {
                    auditInfo = new HashMap<String, String>();
                    exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                }
                auditInfo.put("client_id", claims.getStringClaimValue("client_id"));
                auditInfo.put("user_id", claims.getStringClaimValue("user_id"));
                auditInfo.put("subject_claims", (String)claims);
                if (config != null && ((Boolean)config.get(ENABLE_VERIFY_JWT_SCOPE_TOKEN)).booleanValue() && OpenApiHelper.openApi3 != null) {
                    Operation operation = null;
                    OpenApiOperation openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation");
                    if (openApiOperation == null) {
                        String httpMethod;
                        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
                        Optional maybeApiPath = OpenApiHelper.findMatchingApiPath((NormalisedPath)requestPath);
                        if (!maybeApiPath.isPresent()) {
                            this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[0]);
                            return;
                        }
                        NormalisedPath swaggerPathString = (NormalisedPath)maybeApiPath.get();
                        Path swaggerPath = OpenApiHelper.openApi3.getPath(swaggerPathString.original());
                        operation = swaggerPath.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
                        if (operation == null) {
                            this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                            return;
                        }
                        openApiOperation = new OpenApiOperation(swaggerPathString, swaggerPath, httpMethod, operation);
                        auditInfo.put("openapi_operation", (String)openApiOperation);
                        auditInfo.put("endpoint", swaggerPathString.normalised() + "@" + httpMethod);
                    } else {
                        operation = openApiOperation.getOperation();
                    }
                    String scopeHeader = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
                    String scopeJwt = JwtVerifier.getJwtFromAuthorization((String)scopeHeader);
                    List secondaryScopes = null;
                    if (scopeJwt != null) {
                        try {
                            JwtClaims scopeClaims = jwtVerifier.verifyJwt(scopeJwt, false, true);
                            secondaryScopes = scopeClaims.getStringListClaimValue("scope");
                            auditInfo.put("scope_client_id", scopeClaims.getStringClaimValue("client_id"));
                            auditInfo.put("access_claims", (String)scopeClaims);
                        }
                        catch (MalformedClaimException | InvalidJwtException e) {
                            logger.error("InvalidJwtException", e);
                            this.setExchangeStatus(exchange, STATUS_INVALID_SCOPE_TOKEN, new Object[0]);
                            return;
                        }
                        catch (ExpiredTokenException e) {
                            logger.error("ExpiredTokenException", (Throwable)e);
                            this.setExchangeStatus(exchange, STATUS_SCOPE_TOKEN_EXPIRED, new Object[0]);
                            return;
                        }
                    }
                    if (((Boolean)config.get(ENABLE_VERIFY_SCOPE)).booleanValue()) {
                        List specScopes = null;
                        List securityRequirements = operation.getSecurityRequirements();
                        if (securityRequirements != null) {
                            SecurityRequirement requirement;
                            SecurityParameter securityParameter;
                            Iterator iterator = securityRequirements.iterator();
                            while (iterator.hasNext() && (specScopes = (securityParameter = (requirement = (SecurityRequirement)iterator.next()).getRequirement(OpenApiHelper.oauth2Name)).getParameters()) == null) {
                            }
                        }
                        if (scopeHeader != null) {
                            if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                                this.setExchangeStatus(exchange, STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, new Object[]{secondaryScopes, specScopes});
                                return;
                            }
                        } else {
                            List primaryScopes;
                            try {
                                primaryScopes = claims.getStringListClaimValue("scope");
                            }
                            catch (MalformedClaimException e) {
                                logger.error("MalformedClaimException", (Throwable)e);
                                this.setExchangeStatus(exchange, STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                                return;
                            }
                            if (!this.matchedScopes(primaryScopes, specScopes)) {
                                this.setExchangeStatus(exchange, STATUS_AUTH_TOKEN_SCOPE_MISMATCH, new Object[]{primaryScopes, specScopes});
                                return;
                            }
                        }
                    }
                }
                Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            }
            catch (InvalidJwtException e) {
                logger.error("InvalidJwtException: ", (Throwable)e);
                this.setExchangeStatus(exchange, STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", (Throwable)e);
                this.setExchangeStatus(exchange, STATUS_AUTH_TOKEN_EXPIRED, new Object[0]);
            }
        } else {
            this.setExchangeStatus(exchange, STATUS_MISSING_AUTH_TOKEN, new Object[0]);
        }
    }

    protected boolean matchedScopes(List<String> jwtScopes, Collection<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (jwtScopes != null && jwtScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!jwtScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        Object object = config.get("enableVerifyJwt");
        return object != null && Boolean.valueOf(object.toString()) != false;
    }

    public void register() {
        ModuleRegistry.registerModule((String)JwtVerifyHandler.class.getName(), config, null);
    }

    public JwtVerifier getJwtVerifier() {
        return jwtVerifier;
    }

    static {
        if (config == null) {
            config = Config.getInstance().getJsonMapConfig("security");
        }
        jwtVerifier = new JwtVerifier(config);
    }
}

