/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.inmemory;

import com.networknt.eventuate.jdbc.IdGenerator;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.consumer.MessageConsumer;
import com.networknt.tram.message.consumer.MessageHandler;
import com.networknt.tram.message.producer.MessageProducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMessaging
implements MessageProducer,
MessageConsumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IdGenerator idGenerator = (IdGenerator)SingletonServiceFactory.getBean(IdGenerator.class);
    private Executor executor = Executors.newCachedThreadPool();
    private Map<String, List<MessageHandler>> subscriptions = new HashMap<String, List<MessageHandler>>();

    public void send(String destination, Message message) {
        String id = this.idGenerator.genId().asString();
        message.getHeaders().put("ID", id);
        this.reallySend(destination, message);
    }

    private void reallySend(String destination, Message message) {
        List handlers = this.subscriptions.getOrDefault(destination, Collections.emptyList());
        this.logger.info("sending to channel {} that has {} subscriptions this message {} ", new Object[]{destination, handlers.size(), message});
        for (MessageHandler handler : handlers) {
            try {
                handler.accept((Object)message);
            }
            catch (Throwable t) {
                this.logger.error("message handler " + destination, t);
            }
        }
    }

    public void subscribe(String subscriberId, Set<String> channels, MessageHandler handler) {
        this.logger.info("subscribing {} to channels {}", (Object)subscriberId, channels);
        for (String channel : channels) {
            List<MessageHandler> handlers = this.subscriptions.get(channel);
            if (handlers == null) {
                handlers = new ArrayList<MessageHandler>();
                this.subscriptions.put(channel, handlers);
            }
            handlers.add(handler);
        }
    }

    public void close() {
        this.subscriptions.clear();
    }
}

