package com.spotify.apollo.meta.model;

import io.norberg.automatter.AutoMatter;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class MetaInfoBuilder {
  private String componentId;

  private String buildVersion;

  private String containerVersion;

  private String systemVersion;

  private double serviceUptime;

  public MetaInfoBuilder() {
  }

  private MetaInfoBuilder(Model.MetaInfo v) {
    this.componentId = v.componentId();
    this.buildVersion = v.buildVersion();
    this.containerVersion = v.containerVersion();
    this.systemVersion = v.systemVersion();
    this.serviceUptime = v.serviceUptime();
  }

  private MetaInfoBuilder(MetaInfoBuilder v) {
    this.componentId = v.componentId;
    this.buildVersion = v.buildVersion;
    this.containerVersion = v.containerVersion;
    this.systemVersion = v.systemVersion;
    this.serviceUptime = v.serviceUptime;
  }

  public String componentId() {
    return componentId;
  }

  public MetaInfoBuilder componentId(String componentId) {
    if (componentId == null) {
      throw new NullPointerException("componentId");
    }
    this.componentId = componentId;
    return this;
  }

  public String buildVersion() {
    return buildVersion;
  }

  public MetaInfoBuilder buildVersion(String buildVersion) {
    if (buildVersion == null) {
      throw new NullPointerException("buildVersion");
    }
    this.buildVersion = buildVersion;
    return this;
  }

  public String containerVersion() {
    return containerVersion;
  }

  public MetaInfoBuilder containerVersion(String containerVersion) {
    if (containerVersion == null) {
      throw new NullPointerException("containerVersion");
    }
    this.containerVersion = containerVersion;
    return this;
  }

  public String systemVersion() {
    return systemVersion;
  }

  public MetaInfoBuilder systemVersion(@Nullable String systemVersion) {
    this.systemVersion = systemVersion;
    return this;
  }

  public double serviceUptime() {
    return serviceUptime;
  }

  public MetaInfoBuilder serviceUptime(double serviceUptime) {
    this.serviceUptime = serviceUptime;
    return this;
  }

  public Model.MetaInfo build() {
    return new Value(componentId, buildVersion, containerVersion, systemVersion, serviceUptime);
  }

  public static MetaInfoBuilder from(Model.MetaInfo v) {
    return new MetaInfoBuilder(v);
  }

  public static MetaInfoBuilder from(MetaInfoBuilder v) {
    return new MetaInfoBuilder(v);
  }

  private static final class Value implements Model.MetaInfo {
    private final String componentId;

    private final String buildVersion;

    private final String containerVersion;

    private final String systemVersion;

    private final double serviceUptime;

    private Value(@AutoMatter.Field("componentId") String componentId,
        @AutoMatter.Field("buildVersion") String buildVersion,
        @AutoMatter.Field("containerVersion") String containerVersion,
        @AutoMatter.Field("systemVersion") String systemVersion,
        @AutoMatter.Field("serviceUptime") double serviceUptime) {
      if (componentId == null) {
        throw new NullPointerException("componentId");
      }
      if (buildVersion == null) {
        throw new NullPointerException("buildVersion");
      }
      if (containerVersion == null) {
        throw new NullPointerException("containerVersion");
      }
      this.componentId = componentId;
      this.buildVersion = buildVersion;
      this.containerVersion = containerVersion;
      this.systemVersion = systemVersion;
      this.serviceUptime = serviceUptime;
    }

    @AutoMatter.Field
    @Override
    public String componentId() {
      return componentId;
    }

    @AutoMatter.Field
    @Override
    public String buildVersion() {
      return buildVersion;
    }

    @AutoMatter.Field
    @Override
    public String containerVersion() {
      return containerVersion;
    }

    @AutoMatter.Field
    @Override
    public String systemVersion() {
      return systemVersion;
    }

    @AutoMatter.Field
    @Override
    public double serviceUptime() {
      return serviceUptime;
    }

    public MetaInfoBuilder builder() {
      return new MetaInfoBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Model.MetaInfo)) {
        return false;
      }
      final Model.MetaInfo that = (Model.MetaInfo) o;
      if (componentId != null ? !componentId.equals(that.componentId()) : that.componentId() != null) {
        return false;
      }
      if (buildVersion != null ? !buildVersion.equals(that.buildVersion()) : that.buildVersion() != null) {
        return false;
      }
      if (containerVersion != null ? !containerVersion.equals(that.containerVersion()) : that.containerVersion() != null) {
        return false;
      }
      if (systemVersion != null ? !systemVersion.equals(that.systemVersion()) : that.systemVersion() != null) {
        return false;
      }
      if (Double.compare(serviceUptime, that.serviceUptime()) != 0) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.componentId != null ? this.componentId.hashCode() : 0);
      result = 31 * result + (this.buildVersion != null ? this.buildVersion.hashCode() : 0);
      result = 31 * result + (this.containerVersion != null ? this.containerVersion.hashCode() : 0);
      result = 31 * result + (this.systemVersion != null ? this.systemVersion.hashCode() : 0);
      temp = Double.doubleToLongBits(this.serviceUptime);
      result = 31 * result + (int) (temp ^ (temp >>> 32));
      return result;
    }

    @Override
    public String toString() {
      return "Model.MetaInfo{" +
      "componentId=" + componentId +
      ", buildVersion=" + buildVersion +
      ", containerVersion=" + containerVersion +
      ", systemVersion=" + systemVersion +
      ", serviceUptime=" + serviceUptime +
      '}';
    }
  }
}
