package com.spotify.apollo.request;

import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestMetadata;
import java.util.Map;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RequestContexts extends RequestContexts {

  private final Request request;

  private final Client requestScopedClient;

  private final Map<String, String> pathArgs;

  private final long arrivalTimeNanos;

  private final RequestMetadata metadata;

  AutoValue_RequestContexts(
      Request request,
      Client requestScopedClient,
      Map<String, String> pathArgs,
      long arrivalTimeNanos,
      RequestMetadata metadata) {
    if (request == null) {
      throw new NullPointerException("Null request");
    }
    this.request = request;
    if (requestScopedClient == null) {
      throw new NullPointerException("Null requestScopedClient");
    }
    this.requestScopedClient = requestScopedClient;
    if (pathArgs == null) {
      throw new NullPointerException("Null pathArgs");
    }
    this.pathArgs = pathArgs;
    this.arrivalTimeNanos = arrivalTimeNanos;
    if (metadata == null) {
      throw new NullPointerException("Null metadata");
    }
    this.metadata = metadata;
  }

  @Override
  public Request request() {
    return request;
  }

  @Override
  public Client requestScopedClient() {
    return requestScopedClient;
  }

  @Override
  public Map<String, String> pathArgs() {
    return pathArgs;
  }

  @Override
  public long arrivalTimeNanos() {
    return arrivalTimeNanos;
  }

  @Override
  public RequestMetadata metadata() {
    return metadata;
  }

  @Override
  public String toString() {
    return "RequestContexts{"
        + "request=" + request + ", "
        + "requestScopedClient=" + requestScopedClient + ", "
        + "pathArgs=" + pathArgs + ", "
        + "arrivalTimeNanos=" + arrivalTimeNanos + ", "
        + "metadata=" + metadata
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RequestContexts) {
      RequestContexts that = (RequestContexts) o;
      return this.request.equals(that.request())
          && this.requestScopedClient.equals(that.requestScopedClient())
          && this.pathArgs.equals(that.pathArgs())
          && this.arrivalTimeNanos == that.arrivalTimeNanos()
          && this.metadata.equals(that.metadata());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= request.hashCode();
    h$ *= 1000003;
    h$ ^= requestScopedClient.hashCode();
    h$ *= 1000003;
    h$ ^= pathArgs.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((arrivalTimeNanos >>> 32) ^ arrivalTimeNanos);
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    return h$;
  }

}
