/*
 * -\-\-
 * Spotify Apollo API Implementations
 * --
 * Copyright (C) 2013 - 2015 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */
package com.spotify.apollo.request;

import com.google.auto.value.AutoValue;

import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.RequestMetadata;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class RequestContexts implements RequestContext {

  /**
   * @deprecated - prefer {@link #create(Request, Client, Map, long, RequestMetadata)} to specify
   * correct metadata.
   */
  @Deprecated
  public static RequestContext create(
      Request request, Client client, Map<String, String> pathArgs) {
    return create(request, client, pathArgs, System.nanoTime());
  }

  /**
   * @deprecated - prefer {@link #create(Request, Client, Map, long, RequestMetadata)} to specify
   * correct metadata.
   */
  @Deprecated
  public static RequestContext create(Request request, Client client, Map<String, String> pathArgs, long arrivalTimeNanos) {
    return create(
        request,
        client,
        pathArgs,
        arrivalTimeNanos,
        RequestMetadataImpl.create(Instant.EPOCH, Optional.empty(), Optional.empty())
    );
  }

  public static RequestContext create(
      Request request,
      Client client,
      Map<String, String> pathArgs,
      long arrivalTimeNanos,
      RequestMetadata metadata) {
    return new AutoValue_RequestContexts(request, client, pathArgs, arrivalTimeNanos, metadata);
  }

  // override default methods from interface to ensure AutoValue generates fields

  @Override
  public abstract long arrivalTimeNanos();

  @Override
  public abstract RequestMetadata metadata();
}
