/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.spotify.apollo.Client;
import com.spotify.apollo.environment.EnvironmentConfigResolver;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.spotify.apollo.environment.EnvironmentFactoryImpl;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvironmentFactoryBuilder {
    private final String backendDomain;
    private final Client client;
    private final Closer closer;
    private final EnvironmentFactory.Resolver resolver;
    private final Optional<EnvironmentConfigResolver> configResolver;

    EnvironmentFactoryBuilder(String backendDomain, Client client, Closer closer, EnvironmentFactory.Resolver resolver) {
        this(backendDomain, client, closer, resolver, Optional.empty());
    }

    EnvironmentFactoryBuilder(String backendDomain, Client client, Closer closer, EnvironmentFactory.Resolver resolver, Optional<EnvironmentConfigResolver> configResolver) {
        this.backendDomain = Objects.requireNonNull(backendDomain, "backendDomain");
        this.client = Objects.requireNonNull(client, "client");
        this.closer = Objects.requireNonNull(closer, "closer");
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.configResolver = Objects.requireNonNull(configResolver, "configResolver");
    }

    public EnvironmentFactoryBuilder withConfigResolver(EnvironmentConfigResolver configResolver) {
        Preconditions.checkState((!this.configResolver.isPresent() ? 1 : 0) != 0, (Object)"Configuration resolution already set");
        return new EnvironmentFactoryBuilder(this.backendDomain, this.client, this.closer, this.resolver, Optional.of(configResolver));
    }

    public EnvironmentFactoryBuilder withStaticConfig(Config configNode) {
        Preconditions.checkState((!this.configResolver.isPresent() ? 1 : 0) != 0, (Object)"Configuration resolution already set");
        return new EnvironmentFactoryBuilder(this.backendDomain, this.client, this.closer, this.resolver, Optional.of(new StaticConfigResolver(configNode)));
    }

    public EnvironmentFactoryBuilder withClassLoader(ClassLoader classLoader) {
        Preconditions.checkState((!this.configResolver.isPresent() ? 1 : 0) != 0, (Object)"Configuration resolution already set");
        return new EnvironmentFactoryBuilder(this.backendDomain, this.client, this.closer, this.resolver, Optional.of(new LazyConfigResolver(classLoader)));
    }

    public EnvironmentFactory build() {
        EnvironmentConfigResolver configResolver = this.configResolver.isPresent() ? this.configResolver.get() : new LazyConfigResolver();
        return new EnvironmentFactoryImpl(this.backendDomain, this.client, configResolver, this.resolver, this.closer);
    }

    public static EnvironmentFactoryBuilder newBuilder(String backendDomain, Client client, Closer closer, EnvironmentFactory.Resolver resolver) {
        return new EnvironmentFactoryBuilder(backendDomain, client, closer, resolver);
    }

    static class LazyConfigResolver
    implements EnvironmentConfigResolver {
        private final Logger LOG = LoggerFactory.getLogger(LazyConfigResolver.class);
        private final Optional<ClassLoader> configClassLoader;
        private Config configNode;

        LazyConfigResolver() {
            this.configClassLoader = Optional.empty();
        }

        LazyConfigResolver(ClassLoader configClassLoader) {
            this.configClassLoader = Optional.of(configClassLoader);
        }

        @Override
        public synchronized Config getConfig(String serviceName) {
            if (this.configNode == null) {
                this.configNode = this.configClassLoader.isPresent() ? ConfigFactory.load((ClassLoader)this.configClassLoader.get(), (String)serviceName) : ConfigFactory.load((String)serviceName);
            }
            return this.configNode;
        }
    }

    static class StaticConfigResolver
    implements EnvironmentConfigResolver {
        private final Config configNode;

        StaticConfigResolver(Config configNode) {
            this.configNode = configNode;
        }

        @Override
        public Config getConfig(String ignored) {
            return this.configNode;
        }
    }
}

