/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.io.Closer;
import com.spotify.apollo.Client;
import com.spotify.apollo.Environment;
import com.spotify.apollo.environment.EnvironmentConfigResolver;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.typesafe.config.Config;
import java.util.Objects;

class EnvironmentImpl
implements Environment {
    private final String serviceName;
    private final String domain;
    private final Client client;
    private final EnvironmentConfigResolver configResolver;
    private final EnvironmentFactory.Resolver resolver;
    private final EnvironmentFactory.RoutingContext routingContext;
    private final Closer closer;

    EnvironmentImpl(String serviceName, String domain, Client client, EnvironmentConfigResolver configResolver, EnvironmentFactory.Resolver resolver, EnvironmentFactory.RoutingContext routingContext, Closer closer) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
        this.domain = Objects.requireNonNull(domain, "domain");
        this.client = Objects.requireNonNull(client, "client");
        this.configResolver = Objects.requireNonNull(configResolver, "configResolver");
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.routingContext = Objects.requireNonNull(routingContext, "routingContext");
        this.closer = Objects.requireNonNull(closer, "closer");
    }

    public String domain() {
        return this.domain;
    }

    public Client client() {
        return this.client;
    }

    public Config config() {
        return this.configResolver.getConfig(this.serviceName);
    }

    public Environment.RoutingEngine routingEngine() {
        return this.routingContext;
    }

    public Closer closer() {
        return this.closer;
    }

    public <T> T resolve(Class<T> clazz) {
        return this.resolver.resolve(clazz);
    }
}

