/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.spotify.apollo.Request;
import com.spotify.apollo.route.ApplicationRouter;
import com.spotify.apollo.route.InvalidUriException;
import com.spotify.apollo.route.RuleMatch;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class ApplicationOrMetaRouter<E>
implements ApplicationRouter<E> {
    final ApplicationRouter<E> applicationRouter;
    final ApplicationRouter<E> metaRouter;
    private static final String META = "/_meta/";

    public ApplicationOrMetaRouter(ApplicationRouter<E> applicationRouter, ApplicationRouter<E> metaRouter) {
        this.applicationRouter = applicationRouter;
        this.metaRouter = metaRouter;
    }

    public Optional<RuleMatch<E>> match(Request message) throws InvalidUriException {
        String uri = message.uri();
        if (ApplicationOrMetaRouter.isMeta(uri)) {
            return this.metaRouter.match(message);
        }
        return this.applicationRouter.match(message);
    }

    @VisibleForTesting
    static boolean isMeta(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return uri.getPath().startsWith(META);
    }

    public Collection<String> getMethodsForValidRules(Request message) {
        HashSet union = Sets.newHashSet();
        union.addAll(this.applicationRouter.getMethodsForValidRules(message));
        union.addAll(this.metaRouter.getMethodsForValidRules(message));
        return union;
    }

    public List<E> getRuleTargets() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)this.applicationRouter.getRuleTargets());
        builder.addAll((Iterable)this.metaRouter.getRuleTargets());
        return builder.build();
    }
}

