/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Throwables;
import com.spotify.apollo.Payloads;
import com.spotify.apollo.Request;
import com.spotify.apollo.Serializer;
import com.spotify.apollo.meta.TypesafeConfigSerializer;
import com.typesafe.config.ConfigValue;
import io.norberg.automatter.jackson.AutoMatterModule;
import okio.ByteString;

public class JsonMetaSerializer
implements Serializer {
    private static final ObjectMapper MAPPER;
    private static final ObjectMapper OBJECT_MAPPER;

    public Serializer.Payload serialize(Request message, Object o) {
        ObjectMapper usedMapper = message.parameter("origins").isPresent() ? OBJECT_MAPPER : MAPPER;
        try {
            return Payloads.create((ByteString)ByteString.encodeUtf8((String)usedMapper.writeValueAsString(o)), (String)"application/json");
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        SimpleModule configModule = new SimpleModule();
        SimpleModule configModuleWithOrigins = new SimpleModule();
        configModule.addSerializer(ConfigValue.class, (JsonSerializer)new TypesafeConfigSerializer(false));
        configModuleWithOrigins.addSerializer(ConfigValue.class, (JsonSerializer)new TypesafeConfigSerializer(true));
        MAPPER = new ObjectMapper().registerModule((Module)new AutoMatterModule()).registerModule((Module)configModule);
        OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new AutoMatterModule()).registerModule((Module)configModuleWithOrigins);
    }
}

