/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.spotify.apollo.Serializer;
import com.spotify.apollo.meta.JsonMetaSerializer;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.meta.model.Model;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middlewares;
import com.spotify.apollo.route.Route;
import com.spotify.apollo.route.RouteProvider;
import java.util.stream.Stream;

public class MetaApplication
implements RouteProvider {
    private static final String BASE_META_0 = "/_meta/0";
    private static final Serializer JSON_META = new JsonMetaSerializer();
    private final MetaGatherer gatherer;

    public MetaApplication(MetaGatherer gatherer) {
        this.gatherer = gatherer;
    }

    public Stream<Route<? extends AsyncHandler<?>>> routes() {
        return Stream.of(Route.sync((String)"GET", (String)"/_meta/0/info", requestContext -> this.info()).withDocString("Collects short, bounded, pieces of information about the service, such as build version and uptime.", ""), Route.sync((String)"GET", (String)"/_meta/0/config", requestContext -> this.config()).withDocString("The current loaded config of the service, possibly filtered.", ""), Route.sync((String)"GET", (String)"/_meta/0/endpoints", requestContext -> this.endpoints()).withDocString("Lists the endpoints of the service, with as much metadata as available.", ""), Route.sync((String)"GET", (String)"/_meta/0/calls", requestContext -> this.calls()).withDocString("Lists outgoing/incoming services to/from which calls have been made from/to the service.", "")).map(route -> route.withMiddleware(Middlewares.serialize(JSON_META)));
    }

    Result<Model.MetaInfo> info() {
        return new Result<Model.MetaInfo>(this.gatherer.info());
    }

    Result<Model.LoadedConfig> config() {
        return new Result<Model.LoadedConfig>(this.gatherer.loadedConfig());
    }

    Result<Model.EndpointsInfo> endpoints() {
        return new Result<Model.EndpointsInfo>(this.gatherer.endpoints());
    }

    Result<Model.ExternalCallsInfo> calls() {
        return new Result<Model.ExternalCallsInfo>(this.gatherer.calls());
    }

    public static class Result<T> {
        public final T result;

        public Result(T result) {
            this.result = result;
        }
    }
}

