/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.spotify.apollo.meta.Descriptor;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDescriptor.class);
    private static final String IMPL_VERSION = "Implementation-Version";
    private final Descriptor descriptor;
    private final String apolloVersion;

    MetaDescriptor(Descriptor descriptor, String apolloVersion) {
        this.descriptor = descriptor;
        this.apolloVersion = apolloVersion;
    }

    public Descriptor descriptor() {
        return this.descriptor;
    }

    public String apolloVersion() {
        return this.apolloVersion;
    }

    public static MetaDescriptor readMetaDescriptor(String serviceName, ClassLoader classLoader) throws IOException {
        String apolloVersion;
        try {
            apolloVersion = MetaDescriptor.loadApolloVersion(classLoader);
        }
        catch (IOException e) {
            apolloVersion = "0.0.0-UNKNOWN";
        }
        String version = MetaDescriptor.loadVersion(classLoader);
        version = version != null ? version : "0.0.0-UNKNOWN";
        return new MetaDescriptor(Descriptor.create(serviceName, version), apolloVersion);
    }

    protected static String loadApolloVersion(ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        properties.load(classLoader.getResourceAsStream("metaDescriptor.properties"));
        return properties.getProperty("apolloVersion");
    }

    private static String loadVersion(ClassLoader classLoader) throws IOException {
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                Attributes mainAttributes = manifest.getMainAttributes();
                String value = mainAttributes.getValue(IMPL_VERSION);
                if (value == null) continue;
                return value;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read manifest", (Throwable)e);
            throw new IOException("Failed to find manifest", e);
        }
        return null;
    }
}

