/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.meta.OutgoingCallsGatherer;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import okio.ByteString;

public class OutgoingCallsGatheringClient
implements IncomingRequestAwareClient {
    private final OutgoingCallsGatherer callsGatherer;
    private final IncomingRequestAwareClient delegate;

    public OutgoingCallsGatheringClient(OutgoingCallsGatherer callsGatherer, IncomingRequestAwareClient delegate) {
        this.callsGatherer = Objects.requireNonNull(callsGatherer, "callsGatherer");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public CompletionStage<Response<ByteString>> send(Request request, Optional<Request> incoming) {
        URI uri = URI.create(request.uri());
        String service = uri.getAuthority();
        this.callsGatherer.gatherOutgoingCall(service, request);
        return this.delegate.send(request, incoming);
    }
}

