/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.util.Map;

class TypesafeConfigSerializer
extends JsonSerializer<ConfigValue> {
    private final boolean withOrigins;

    TypesafeConfigSerializer(boolean withOrigins) {
        this.withOrigins = withOrigins;
    }

    public void serialize(ConfigValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.valueType() == ConfigValueType.OBJECT) {
            ConfigObject object = (ConfigObject)value;
            jgen.writeStartObject();
            for (Map.Entry valueEntry : object.entrySet()) {
                if (this.withOrigins) {
                    ConfigOrigin origin = ((ConfigValue)valueEntry.getValue()).origin();
                    jgen.writeStringField((String)valueEntry.getKey() + "__origin", origin.description() + (origin.filename() != null ? ", " + origin.filename() : ""));
                }
                jgen.writeObjectField((String)valueEntry.getKey(), valueEntry.getValue());
            }
            jgen.writeEndObject();
        } else if (value.valueType() == ConfigValueType.LIST) {
            ConfigList list = (ConfigList)value;
            jgen.writeStartArray();
            for (ConfigValue configValue : list) {
                jgen.writeObject((Object)configValue);
            }
            jgen.writeEndArray();
        } else {
            jgen.writeObject(value.unwrapped());
        }
    }
}

