/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.spotify.apollo.meta.model.EndpointInfoGatherer;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.meta.model.Model;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

class CallsInfo
implements MetaGatherer.CallsGatherer {
    private int sizeLimit;
    private Model.EndpointsInfo endpointsInfo = new Model.EndpointsInfo();
    private ConcurrentMap<String, EndpointInfoGatherer> endpoints = Maps.newConcurrentMap();

    public CallsInfo(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    Model.EndpointsInfo getEndpointsInfo() {
        this.endpointsInfo.endpoints = Lists.newArrayListWithCapacity((int)this.endpoints.size());
        for (EndpointInfoGatherer endpoint : this.endpoints.values()) {
            this.endpointsInfo.endpoints.add(endpoint.endpointInfo());
        }
        return this.endpointsInfo;
    }

    @Override
    public void setDocstring(String docstring) {
        this.endpointsInfo.docstring = docstring;
    }

    @Override
    public MetaGatherer.EndpointGatherer namedEndpointGatherer(String key) {
        if (!this.endpoints.containsKey(key)) {
            if (this.endpoints.size() < this.sizeLimit) {
                this.endpoints.putIfAbsent(key, new EndpointInfoGatherer(key, this.sizeLimit));
            } else {
                if (!this.endpoints.containsKey("<over size limit>")) {
                    this.endpoints.putIfAbsent("<over size limit>", new EndpointInfoGatherer("<over size limit>", this.sizeLimit));
                }
                return (MetaGatherer.EndpointGatherer)this.endpoints.get("<over size limit>");
            }
        }
        return (MetaGatherer.EndpointGatherer)this.endpoints.get(key);
    }

    @Override
    public MetaGatherer.EndpointGatherer uriMethodsEndpointGatherer(String uri, List<String> methods) {
        StringBuilder key = new StringBuilder(uri);
        key.append('[');
        boolean first = true;
        for (String method : methods) {
            if (first) {
                first = false;
            } else {
                key.append(',');
            }
            key.append(method);
        }
        key.append(']');
        return this.namedEndpointGatherer(key.toString());
    }

    @Override
    public MetaGatherer.EndpointGatherer uriEndpointGatherer(String uri) {
        return this.namedEndpointGatherer(uri);
    }
}

