/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.meta.model.Model;
import java.util.List;
import java.util.Set;

class EndpointInfoGatherer
implements MetaGatherer.EndpointGatherer {
    private int sizeLimit;
    private Model.EndpointInfo endpointInfo = new Model.EndpointInfo();
    private Set<String> methods = Sets.newCopyOnWriteArraySet();
    private Set<String> queryParameters = Sets.newCopyOnWriteArraySet();

    public EndpointInfoGatherer(String methodName, int sizeLimit) {
        this.setMethodName(methodName);
        this.sizeLimit = sizeLimit;
    }

    Model.EndpointInfo endpointInfo() {
        this.endpointInfo.method = Lists.newArrayList(this.methods);
        this.endpointInfo.queryParameters = Lists.newArrayListWithCapacity((int)this.queryParameters.size());
        for (String name : this.queryParameters) {
            this.endpointInfo.queryParameters.add(new Model.QueryParameter(name));
        }
        return this.endpointInfo;
    }

    @Override
    public void setMethodName(String methodName) {
        this.endpointInfo.methodName = methodName;
    }

    @Override
    public void setUri(String uri) {
        this.endpointInfo.uri = uri;
    }

    @Override
    public void setMethods(List<String> methods) {
        this.methods.clear();
        this.methods.addAll(methods);
    }

    @Override
    public void addMethod(String method) {
        if (this.methods.size() < this.sizeLimit) {
            this.methods.add(method);
        } else {
            this.methods.add("<over size limit>");
        }
    }

    @Override
    public void setRequestContentType(String contentType) {
        this.endpointInfo.requestPayloadSchema.contentType = contentType;
    }

    @Override
    public void setResponseContentType(String contentType) {
        this.endpointInfo.replyPayloadSchema.contentType = contentType;
    }

    @Override
    public void setDocstring(String docstring) {
        this.endpointInfo.docstring = docstring;
    }

    @Override
    public void addQueryParameterName(String name) {
        if (this.queryParameters.size() < this.sizeLimit) {
            this.queryParameters.add(name);
        } else {
            this.queryParameters.add("<over size limit>");
        }
    }
}

