/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.google.common.collect.Maps;
import com.typesafe.config.ConfigObject;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface Model {

    public static class PayloadSchema {
        public String contentType;
    }

    public static class QueryParameter {
        public final String name;

        public QueryParameter(String name) {
            this.name = name;
        }
    }

    public static class ExternalCallsInfo {
        public Map<String, List<EndpointInfo>> incoming = Maps.newTreeMap();
        public Map<String, List<EndpointInfo>> outgoing = Maps.newTreeMap();
    }

    public static class EndpointInfo {
        public String methodName;
        public String uri;
        public List<String> method;
        public String docstring;
        public PayloadSchema requestPayloadSchema = new PayloadSchema();
        public PayloadSchema replyPayloadSchema = new PayloadSchema();
        public List<QueryParameter> queryParameters;
    }

    public static class EndpointsInfo {
        public String docstring;
        public List<EndpointInfo> endpoints;
    }

    @AutoMatter
    public static interface LoadedConfig {
        public ConfigObject spNode();
    }

    @AutoMatter
    public static interface MetaInfo {
        public String componentId();

        public String buildVersion();

        public String containerVersion();

        @Nullable
        public String systemVersion();

        public double serviceUptime();
    }
}

