/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.request;

import com.spotify.apollo.Client;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestContexts;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.RequestRunnableFactory;
import com.spotify.apollo.route.RuleMatch;
import java.util.Map;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandlerImpl
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandlerImpl.class);
    private final RequestRunnableFactory rrf;
    private final EndpointRunnableFactory erf;
    private final IncomingRequestAwareClient client;

    RequestHandlerImpl(RequestRunnableFactory requestRunnableFactory, EndpointRunnableFactory endpointRunnableFactory, IncomingRequestAwareClient client) {
        this.rrf = requestRunnableFactory;
        this.erf = endpointRunnableFactory;
        this.client = client;
    }

    @Override
    public void handle(OngoingRequest ongoingRequest) {
        try {
            this.rrf.create(ongoingRequest).run(this::handleEndpointMatch);
        }
        catch (Exception e) {
            LOGGER.error("Request matching/handling threw exception", (Throwable)e);
            try {
                ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR));
            }
            catch (Throwable t) {
                LOGGER.error("Caught throwable when replying with Internal Server Error", t);
            }
        }
    }

    private void handleEndpointMatch(OngoingRequest request, RuleMatch<Endpoint> match) {
        Endpoint endpoint = (Endpoint)match.getRule().getTarget();
        Map parsedPathArguments = match.parsedPathArguments();
        Client requestScopedClient = this.client.wrapRequest(request.request());
        RequestContext requestContext = RequestContexts.create(request.request(), requestScopedClient, parsedPathArguments, request.arrivalTimeNanos(), request.metadata());
        this.erf.create(request, requestContext, endpoint).run();
    }
}

