/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.request;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.request.OngoingRequest;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RequestTracker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RequestTracker.class);
    private static final ScheduledExecutorService TRACKER_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("apollo-request-reaper").build());
    private final Set<OngoingRequest> outstanding = ConcurrentHashMap.newKeySet();
    private final ScheduledFuture<?> future = TRACKER_EXECUTOR.scheduleWithFixedDelay(this::reap, 10L, 10L, TimeUnit.MILLISECONDS);

    public void register(OngoingRequest request) {
        this.outstanding.add(request);
    }

    public boolean remove(OngoingRequest request) {
        return this.outstanding.remove(request);
    }

    @Override
    public void close() {
        this.future.cancel(false);
        try {
            Futures.getUnchecked(this.future);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.failRequests();
    }

    @VisibleForTesting
    void reap() {
        this.outstanding.stream().filter(OngoingRequest::isExpired).forEach(request -> {
            LOG.warn("Dropping expired request: {}", request);
            request.drop();
        });
    }

    private void failRequests() {
        ImmutableSet requests = ImmutableSet.copyOf(this.outstanding);
        for (OngoingRequest id : requests) {
            boolean removed = this.outstanding.remove(id);
            if (!removed) continue;
            id.reply((Response<ByteString>)Response.forStatus((StatusType)Status.SERVICE_UNAVAILABLE));
        }
    }
}

