/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.dispatch.EndpointInfo;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import java.util.concurrent.CompletionStage;
import okio.ByteString;

class RouteEndpoint
implements Endpoint {
    private final Route<? extends AsyncHandler<Response<ByteString>>> target;
    private final String methodName;

    RouteEndpoint(Route<? extends AsyncHandler<Response<ByteString>>> target) {
        this(target, "invoke");
    }

    RouteEndpoint(Route<? extends AsyncHandler<Response<ByteString>>> target, String methodName) {
        this.target = target;
        this.methodName = methodName;
    }

    @Override
    public EndpointInfo info() {
        return new EndpointInfo(this.target.uri(), this.target.method(), this.methodName, this.target.docString());
    }

    @Override
    public CompletionStage<Response<ByteString>> invoke(RequestContext requestContext) {
        return ((AsyncHandler)this.target.handler()).invoke(requestContext);
    }
}

