/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.Response;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.route.ApplicationRouter;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middlewares;
import com.spotify.apollo.route.Route;
import com.spotify.apollo.route.RouteProvider;
import com.spotify.apollo.route.RouteRuleBuilder;
import com.spotify.apollo.route.Rule;
import com.spotify.apollo.route.RuleRouter;
import java.util.ArrayList;
import java.util.List;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Routers {
    private static final Logger LOG = LoggerFactory.getLogger(Routers.class);

    private Routers() {
    }

    public static ApplicationRouter<Endpoint> newRouterFromInspecting(Object ... objects) {
        return RuleRouter.of(Routers.rules(objects));
    }

    private static List<Rule<Endpoint>> rules(Object ... objects) {
        ArrayList<Rule<Endpoint>> rules = new ArrayList<Rule<Endpoint>>();
        for (Object object : objects) {
            if (object instanceof Route) {
                rules.add(RouteRuleBuilder.toRule((Route<? extends AsyncHandler<Response<ByteString>>>)((Route)object)));
                continue;
            }
            if (object instanceof RouteProvider) {
                ((RouteProvider)object).routes().map(route -> route.withMiddleware(Middlewares.apolloDefaults())).map(RouteRuleBuilder::toRule).forEachOrdered(rules::add);
                continue;
            }
            throw new IllegalArgumentException("Unknown route/rule instance detected " + object);
        }
        return rules;
    }
}

