/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics;

import com.spotify.ffwd.http.HttpDiscovery;
import com.typesafe.config.Config;
import java.util.Collections;

public interface DiscoveryConfig {
    public HttpDiscovery toHttpDiscovery();

    public static DiscoveryConfig fromConfig(Config config) {
        String type;
        switch (type = config.getString("type")) {
            case "static": {
                String host = config.getString("host");
                int port = config.getInt("port");
                return new Static(host, port);
            }
            case "srv": {
                String record = config.getString("record");
                return new Srv(record);
            }
        }
        throw new RuntimeException("Unrecognized discovery type: " + type);
    }

    public static class Srv
    implements DiscoveryConfig {
        private final String record;

        Srv(String record) {
            this.record = record;
        }

        String getRecord() {
            return this.record;
        }

        @Override
        public HttpDiscovery toHttpDiscovery() {
            return new HttpDiscovery.Srv(this.record);
        }
    }

    public static class Static
    implements DiscoveryConfig {
        private final String host;
        private final int port;

        Static(String host, int port) {
            this.host = host;
            this.port = port;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }

        @Override
        public HttpDiscovery toHttpDiscovery() {
            HttpDiscovery.HostAndPort server = new HttpDiscovery.HostAndPort(this.host, this.port);
            return new HttpDiscovery.Static(Collections.singletonList(server));
        }
    }
}

