/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics;

import com.spotify.apollo.environment.ConfigUtil;
import com.spotify.apollo.metrics.DiscoveryConfig;
import com.spotify.apollo.metrics.FastForwardLifecycle;
import com.spotify.ffwd.http.HttpClient;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwd.FastForwardReporter;
import com.spotify.metrics.ffwdhttp.FastForwardHttpReporter;
import com.spotify.metrics.tags.EnvironmentTagExtractor;
import com.spotify.metrics.tags.TagExtractor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

interface FfwdConfig {
    public static final int DEFAULT_INTERVAL = 30;

    public Callable<FastForwardLifecycle> setup(SemanticMetricRegistry var1, MetricId var2, String var3);

    public static FfwdConfig fromConfig(Config root) {
        Config config = root.hasPath("ffwd") ? root.getConfig("ffwd") : ConfigFactory.empty();
        String type = ConfigUtil.optionalString((Config)config, (String)"type").orElse("agent");
        int interval = ConfigUtil.optionalInt((Config)config, (String)"interval").orElse(30);
        boolean flush = ConfigUtil.optionalBoolean((Config)config, (String)"flush").orElse(Boolean.TRUE);
        switch (type) {
            case "agent": {
                Optional host = ConfigUtil.optionalString((Config)config, (String)"host");
                Optional port = ConfigUtil.optionalInt((Config)config, (String)"port");
                return new Agent(interval, flush, host, port);
            }
            case "http": {
                DiscoveryConfig discovery = DiscoveryConfig.fromConfig(config.getConfig("discovery"));
                return new Http(interval, flush, discovery);
            }
        }
        throw new RuntimeException("Unrecognized ffwd type: " + type);
    }

    public static class Http
    implements FfwdConfig {
        private final int interval;
        private final boolean flush;
        private final DiscoveryConfig discovery;

        Http(int interval, boolean flush, DiscoveryConfig discovery) {
            this.interval = interval;
            this.flush = flush;
            this.discovery = discovery;
        }

        int getInterval() {
            return this.interval;
        }

        boolean getFlush() {
            return this.flush;
        }

        DiscoveryConfig getDiscovery() {
            return this.discovery;
        }

        @Override
        public Callable<FastForwardLifecycle> setup(SemanticMetricRegistry metricRegistry, MetricId metricId, String searchDomain) {
            HttpClient.Builder httpClient = new HttpClient.Builder();
            httpClient.discovery(this.discovery.toHttpDiscovery());
            httpClient.searchDomain(searchDomain);
            FastForwardHttpReporter.Builder builder = FastForwardHttpReporter.forRegistry((SemanticMetricRegistry)metricRegistry, (HttpClient)httpClient.build()).tagExtractor((TagExtractor)new EnvironmentTagExtractor()).schedule((long)this.interval, TimeUnit.SECONDS).prefix(metricId);
            return () -> {
                FastForwardHttpReporter reporter = builder.build();
                reporter.start();
                return this.flush ? () -> ((FastForwardHttpReporter)reporter).stopWithFlush() : () -> ((FastForwardHttpReporter)reporter).stop();
            };
        }
    }

    public static class Agent
    implements FfwdConfig {
        private final int interval;
        private final boolean flush;
        private final Optional<String> host;
        private final Optional<Integer> port;

        Agent(int interval, boolean flush, Optional<String> host, Optional<Integer> port) {
            this.interval = interval;
            this.flush = flush;
            this.host = host;
            this.port = port;
        }

        int getInterval() {
            return this.interval;
        }

        boolean getFlush() {
            return this.flush;
        }

        Optional<String> getHost() {
            return this.host;
        }

        Optional<Integer> getPort() {
            return this.port;
        }

        @Override
        public Callable<FastForwardLifecycle> setup(SemanticMetricRegistry metricRegistry, MetricId metricId, String searchDomain) {
            FastForwardReporter.Builder builder = FastForwardReporter.forRegistry((SemanticMetricRegistry)metricRegistry).schedule(TimeUnit.SECONDS, (long)this.interval).tagExtractor((TagExtractor)new EnvironmentTagExtractor()).prefix(metricId);
            this.host.ifPresent(arg_0 -> ((FastForwardReporter.Builder)builder).host(arg_0));
            this.port.ifPresent(arg_0 -> ((FastForwardReporter.Builder)builder).port(arg_0));
            return () -> {
                FastForwardReporter reporter = builder.build();
                reporter.start();
                return this.flush ? () -> ((FastForwardReporter)reporter).stopWithFlush() : () -> ((FastForwardReporter)reporter).stop();
            };
        }
    }
}

