/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics;

import com.google.inject.Inject;
import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.RequestMetadata;
import com.spotify.apollo.environment.EndpointRunnableFactoryDecorator;
import com.spotify.apollo.metrics.InstrumentingClient;
import com.spotify.apollo.metrics.MetricsTrackingOngoingRequest;
import com.spotify.apollo.metrics.RequestMetrics;
import com.spotify.apollo.metrics.ServiceMetrics;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestContexts;
import java.util.Map;

class MetricsCollectingEndpointRunnableFactoryDecorator
implements EndpointRunnableFactoryDecorator {
    private final ServiceMetrics metrics;

    @Inject
    MetricsCollectingEndpointRunnableFactoryDecorator(ServiceMetrics metrics) {
        this.metrics = metrics;
    }

    public EndpointRunnableFactory apply(EndpointRunnableFactory delegate) {
        return (request, requestContext, endpoint) -> {
            String endpointName = endpoint.info().getName();
            RequestMetrics requestStats = this.metrics.metricsForEndpointCall(endpointName);
            requestStats.incoming(request.request());
            MetricsTrackingOngoingRequest trackedRequest = new MetricsTrackingOngoingRequest(requestStats, request);
            InstrumentingClient instrumentingClient = new InstrumentingClient(requestContext.requestScopedClient(), trackedRequest);
            RequestContext instrumentingContext = RequestContexts.create((Request)requestContext.request(), (Client)instrumentingClient, (Map)requestContext.pathArgs(), (long)requestContext.arrivalTimeNanos(), (RequestMetadata)requestContext.metadata());
            return delegate.create((OngoingRequest)trackedRequest, instrumentingContext, endpoint);
        };
    }
}

