/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.spotify.apollo.environment.ApolloConfig;
import com.spotify.apollo.environment.EndpointRunnableFactoryDecorator;
import com.spotify.apollo.metrics.FastForwardLifecycle;
import com.spotify.apollo.metrics.FfwdConfig;
import com.spotify.apollo.metrics.MetricsCollectingEndpointRunnableFactoryDecorator;
import com.spotify.apollo.metrics.MetricsFactory;
import com.spotify.apollo.metrics.ServiceMetrics;
import com.spotify.apollo.metrics.semantic.MetricsConfig;
import com.spotify.apollo.metrics.semantic.SemanticMetricsFactory;
import com.spotify.apollo.module.AbstractApolloModule;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.ReservoirWithTtl;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.core.SemanticMetricSet;
import com.spotify.metrics.jvm.CpuGaugeSet;
import com.spotify.metrics.jvm.GarbageCollectorMetricSet;
import com.spotify.metrics.jvm.MemoryUsageGaugeSet;
import com.spotify.metrics.jvm.ThreadStatesMetricSet;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsModule
extends AbstractApolloModule {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsModule.class);

    public static MetricsModule create() {
        return new MetricsModule();
    }

    protected void configure() {
        this.bind(MetricsConfig.class);
        Multibinder.newSetBinder((Binder)this.binder(), EndpointRunnableFactoryDecorator.class).addBinding().to(MetricsCollectingEndpointRunnableFactoryDecorator.class);
        this.manageLifecycle(FastForwardLifecycle.class);
    }

    @Provides
    @Singleton
    public SemanticMetricRegistry semanticMetricRegistry(MetricsConfig metricsConfig) {
        SemanticMetricRegistry metricRegistry = new SemanticMetricRegistry(() -> new ReservoirWithTtl(metricsConfig.reservoirTtl()));
        LOG.info("Creating SemanticMetricRegistry");
        metricRegistry.register(MetricId.EMPTY, (Metric)new MemoryUsageGaugeSet());
        metricRegistry.register(MetricId.EMPTY, (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register(MetricId.EMPTY, (Metric)new ThreadStatesMetricSet());
        metricRegistry.register(MetricId.EMPTY, (Metric)CpuGaugeSet.create());
        metricRegistry.register(MetricId.EMPTY, (Metric)new SemanticMetricSet(){
            private FileDescriptorRatioGauge fileDescriptorRatioGauge = new FileDescriptorRatioGauge();

            public Map<MetricId, Metric> getMetrics() {
                HashMap<MetricId, Gauge> gauges = new HashMap<MetricId, Gauge>();
                MetricId metricId = MetricId.build((String[])new String[0]).tagged("what", "file-descriptor-ratio", "unit", "%");
                gauges.put(metricId, () -> {
                    try {
                        return this.fileDescriptorRatioGauge.getValue();
                    }
                    catch (Exception ex) {
                        LOG.debug("Failed to get metrics for FileDescriptorGaugeSet", (Throwable)ex);
                        return RatioGauge.Ratio.of((double)Double.NaN, (double)Double.NaN);
                    }
                });
                return Collections.unmodifiableMap(gauges);
            }
        });
        return metricRegistry;
    }

    @Provides
    @Singleton
    public MetricsFactory apolloMetrics(SemanticMetricRegistry metricRegistry, MetricsConfig metricsConfig) {
        return new SemanticMetricsFactory(metricRegistry, what -> metricsConfig.serverMetrics().contains(what), metricsConfig.precreateCodes(), metricsConfig.durationThresholdConfig());
    }

    @Provides
    @Singleton
    public ServiceMetrics apolloMetrics(MetricsFactory metricsFactory, @Named(value="service-name") String serviceName) {
        return metricsFactory.createForService(serviceName);
    }

    @Provides
    @Singleton
    public FfwdConfig ffwdConfig(Config config) {
        return FfwdConfig.fromConfig(config);
    }

    @Provides
    @Singleton
    public FastForwardLifecycle fastForwardReporter(SemanticMetricRegistry metricRegistry, MetricId metricId, FfwdConfig ffwdConfig, ApolloConfig apolloConfig) throws Exception {
        String searchDomain = apolloConfig.backend();
        return ffwdConfig.setup(metricRegistry, metricId, searchDomain).call();
    }

    public String getId() {
        return "metrics";
    }
}

