/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics;

import com.spotify.apollo.Response;
import com.spotify.apollo.metrics.RequestMetrics;
import com.spotify.apollo.request.ForwardingOngoingRequest;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.TrackedOngoingRequest;
import java.util.concurrent.atomic.AtomicInteger;
import okio.ByteString;

class MetricsTrackingOngoingRequest
extends ForwardingOngoingRequest
implements TrackedOngoingRequest {
    private final RequestMetrics metrics;
    private final AtomicInteger requestCounter = new AtomicInteger();

    MetricsTrackingOngoingRequest(RequestMetrics metrics, OngoingRequest ongoingRequest) {
        super(ongoingRequest);
        this.metrics = metrics;
    }

    public void reply(Response<ByteString> message) {
        this.metrics.fanout(this.requestCounter.get());
        this.metrics.response(message);
        super.reply(message);
    }

    public void drop() {
        this.metrics.drop();
        super.drop();
    }

    public void incrementDownstreamRequests() {
        this.requestCounter.incrementAndGet();
    }
}

