/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DurationThresholdConfig {
    private final Optional<Integer> allEndpoints;
    private final Map<String, Optional<Integer>> goals;

    private DurationThresholdConfig(Optional<Integer> allEndpoints, Map<String, Optional<Integer>> goals) {
        this.allEndpoints = allEndpoints;
        this.goals = goals;
    }

    public Optional<Integer> getDurationThresholdForEndpoint(String endpointMethod) {
        return this.goals.getOrDefault(endpointMethod, this.allEndpoints);
    }

    private static Set<Map.Entry<String, Optional<Integer>>> flattenNestedConfig(Map.Entry<String, ConfigValue> entry) {
        return ((Map)entry.getValue().unwrapped()).entrySet().stream().collect(Collectors.toMap(methodEntry -> String.format("%s:%s", methodEntry.getKey(), entry.getKey()), methodEntry -> Optional.of((Integer)methodEntry.getValue()))).entrySet();
    }

    private static Optional<Integer> parseAllEndpoints(Config config) {
        if (config.hasPath("endpoint-duration-goal.all-endpoints")) {
            return Optional.of(config.getInt("endpoint-duration-goal.all-endpoints"));
        }
        return Optional.empty();
    }

    public static DurationThresholdConfig parseConfig(Config config) {
        if (config.hasPath("endpoint-duration-goal")) {
            Map<String, Optional<Integer>> goals = config.getObject("endpoint-duration-goal").withoutKey("all-endpoints").entrySet().stream().map(entry -> DurationThresholdConfig.flattenNestedConfig(entry)).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new DurationThresholdConfig(DurationThresholdConfig.parseAllEndpoints(config), goals);
        }
        return new DurationThresholdConfig(Optional.empty(), (Map<String, Optional<Integer>>)ImmutableMap.of());
    }
}

