/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.codahale.metrics.Meter;
import com.spotify.apollo.metrics.semantic.What;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;

public class DurationThresholdTracker {
    private final Meter durationThresholdMeter;
    private final Integer threshold;

    public DurationThresholdTracker(MetricId id, SemanticMetricRegistry metricRegistry, Integer threshold) {
        MetricId thresholdId = id.tagged("what", What.ENDPOINT_REQUEST_DURATION_THRESHOLD_RATE.tag()).tagged("threshold", threshold.toString());
        this.durationThresholdMeter = metricRegistry.meter(thresholdId);
        this.threshold = threshold;
    }

    public void markDurationThresholds(long duration) {
        if (duration <= (long)this.threshold.intValue()) {
            this.durationThresholdMeter.mark();
        }
    }
}

