/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.google.inject.Inject;
import com.spotify.apollo.environment.ConfigUtil;
import com.spotify.apollo.metrics.semantic.DurationThresholdConfig;
import com.spotify.apollo.metrics.semantic.What;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MetricsConfig {
    static final Set<What> DEFAULT_ENABLED_METRICS = EnumSet.of(What.ENDPOINT_REQUEST_RATE, new What[]{What.ENDPOINT_REQUEST_DURATION, What.ENDPOINT_REQUEST_DURATION_THRESHOLD_RATE, What.DROPPED_REQUEST_RATE, What.ERROR_RATIO, What.ERROR_RATIO_4XX, What.ERROR_RATIO_5XX});
    static final int DEFAULT_TTL_SECONDS = (int)TimeUnit.MINUTES.toSeconds(5L);
    private final Set<What> enabledMetrics;
    private final Set<Integer> precreateCodes;
    private final DurationThresholdConfig durationThresholdConfig;
    private Config config;

    @Inject
    MetricsConfig(Config config) {
        this.config = config;
        this.enabledMetrics = config.hasPath("metrics.server") ? this.parseConfig(config.getStringList("metrics.server")) : DEFAULT_ENABLED_METRICS;
        this.precreateCodes = config.hasPath("metrics.precreate-codes") ? new HashSet<Integer>(config.getIntList("metrics.precreate-codes")) : Collections.emptySet();
        this.durationThresholdConfig = DurationThresholdConfig.parseConfig(config);
    }

    private Set<What> parseConfig(List<String> metrics) {
        EnumSet<What> result = EnumSet.noneOf(What.class);
        for (String metricName : metrics) {
            result.add(What.valueOf(metricName));
        }
        return result;
    }

    public DurationThresholdConfig durationThresholdConfig() {
        return this.durationThresholdConfig;
    }

    public Set<What> serverMetrics() {
        return this.enabledMetrics;
    }

    public Set<Integer> precreateCodes() {
        return this.precreateCodes;
    }

    public int reservoirTtl() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"metrics.reservoir-ttl").orElse(DEFAULT_TTL_SECONDS);
    }
}

