/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.spotify.apollo.metrics.MetricsFactory;
import com.spotify.apollo.metrics.ServiceMetrics;
import com.spotify.apollo.metrics.semantic.DurationThresholdConfig;
import com.spotify.apollo.metrics.semantic.SemanticServiceMetrics;
import com.spotify.apollo.metrics.semantic.What;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import java.util.Set;
import java.util.function.Predicate;

public class SemanticMetricsFactory
implements MetricsFactory {
    private final SemanticMetricRegistry metricRegistry;
    private final MetricId metricId;
    private final Predicate<What> enabledMetrics;
    private final Set<Integer> precreateCodes;
    private final DurationThresholdConfig durationThresholdConfig;

    public SemanticMetricsFactory(SemanticMetricRegistry metricRegistry, Predicate<What> enabledMetrics, Set<Integer> precreateCodes, DurationThresholdConfig durationThresholdConfig) {
        this.metricRegistry = metricRegistry;
        this.metricId = MetricId.build((String[])new String[0]);
        this.enabledMetrics = enabledMetrics;
        this.precreateCodes = precreateCodes;
        this.durationThresholdConfig = durationThresholdConfig;
    }

    @Override
    public ServiceMetrics createForService(String serviceName) {
        MetricId id = this.metricId.tagged("service", serviceName);
        return new SemanticServiceMetrics(this.metricRegistry, id, this.precreateCodes, this.enabledMetrics, this.durationThresholdConfig);
    }
}

