/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.metrics.RequestMetrics;
import com.spotify.apollo.metrics.semantic.DurationThresholdTracker;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okio.ByteString;

class SemanticRequestMetrics
implements RequestMetrics {
    private final Optional<Consumer<Response<ByteString>>> requestRateCounter;
    private final Optional<Histogram> fanoutHistogram;
    private final Optional<Histogram> requestSizeHistogram;
    private final Optional<Histogram> responseSizeHistogram;
    private final Optional<Timer.Context> timerContext;
    private final Optional<Meter> droppedRequests;
    private final Meter sentReplies;
    private final Meter sentErrors;
    private final Meter sentErrors4xx;
    private final Meter sentErrors5xx;
    private final Optional<DurationThresholdTracker> durationThresholdTracker;

    SemanticRequestMetrics(Optional<Consumer<Response<ByteString>>> requestRateCounter, Optional<Histogram> fanoutHistogram, Optional<Histogram> responseSizeHistogram, Optional<Histogram> requestSizeHistogram, Optional<Timer.Context> timerContext, Optional<Meter> droppedRequests, Meter sentReplies, Meter sentErrors, Meter sentErrors4xx, Meter sentErrors5xx, Optional<DurationThresholdTracker> durationThresholdTracker) {
        this.requestRateCounter = Objects.requireNonNull(requestRateCounter);
        this.fanoutHistogram = Objects.requireNonNull(fanoutHistogram);
        this.responseSizeHistogram = Objects.requireNonNull(responseSizeHistogram);
        this.requestSizeHistogram = Objects.requireNonNull(requestSizeHistogram);
        this.timerContext = Objects.requireNonNull(timerContext);
        this.droppedRequests = Objects.requireNonNull(droppedRequests);
        this.sentReplies = Objects.requireNonNull(sentReplies);
        this.sentErrors = Objects.requireNonNull(sentErrors);
        this.sentErrors4xx = Objects.requireNonNull(sentErrors4xx);
        this.sentErrors5xx = Objects.requireNonNull(sentErrors5xx);
        this.durationThresholdTracker = Objects.requireNonNull(durationThresholdTracker);
    }

    @Override
    public void incoming(Request request) {
        this.requestSizeHistogram.ifPresent(histogram -> request.payload().ifPresent(payload -> histogram.update(payload.size())));
    }

    @Override
    public void fanout(int requests) {
        this.fanoutHistogram.ifPresent(histogram -> histogram.update(requests));
    }

    @Override
    public void response(Response<ByteString> response) {
        this.requestRateCounter.ifPresent(consumer -> consumer.accept(response));
        this.responseSizeHistogram.ifPresent(histogram -> response.payload().ifPresent(payload -> histogram.update(payload.size())));
        this.sentReplies.mark();
        this.timerContext.ifPresent(timer -> {
            long duration = timer.stop();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(duration);
            this.durationThresholdTracker.ifPresent(counter -> counter.markDurationThresholds(durationMs));
        });
        StatusType.Family family = response.status().family();
        if (family != StatusType.Family.INFORMATIONAL && family != StatusType.Family.SUCCESSFUL) {
            this.sentErrors.mark();
        }
        if (family == StatusType.Family.CLIENT_ERROR) {
            this.sentErrors4xx.mark();
        }
        if (family == StatusType.Family.SERVER_ERROR) {
            this.sentErrors5xx.mark();
        }
    }

    @Override
    public void drop() {
        this.droppedRequests.ifPresent(Meter::mark);
        this.timerContext.ifPresent(Timer.Context::stop);
    }
}

