/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.metrics.semantic;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.spotify.apollo.Response;
import com.spotify.apollo.metrics.RequestMetrics;
import com.spotify.apollo.metrics.ServiceMetrics;
import com.spotify.apollo.metrics.semantic.DurationThresholdConfig;
import com.spotify.apollo.metrics.semantic.DurationThresholdTracker;
import com.spotify.apollo.metrics.semantic.SemanticRequestMetrics;
import com.spotify.apollo.metrics.semantic.What;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import okio.ByteString;

class SemanticServiceMetrics
implements ServiceMetrics {
    private static final double ERROR_GAUGE_MINIMUM_REPLY_RATE = 0.001;
    private static final double ERROR_RATIO_MINIMUM = 1.0E-15;
    private final SemanticMetricRegistry metricRegistry;
    private final MetricId metricId;
    private final Predicate<What> enabledMetrics;
    private final Set<Integer> precreateCodes;
    private final LoadingCache<String, CachedMeters> metersCache;
    private final DurationThresholdConfig durationThresholdConfig;

    SemanticServiceMetrics(SemanticMetricRegistry metricRegistry, MetricId id, Set<Integer> precreateCodes, Predicate<What> enabledMetrics, DurationThresholdConfig durationThresholdConfig) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry);
        this.metricId = Objects.requireNonNull(id);
        this.enabledMetrics = Objects.requireNonNull(enabledMetrics);
        this.precreateCodes = ImmutableSet.copyOf(precreateCodes);
        this.durationThresholdConfig = durationThresholdConfig;
        this.metersCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, CachedMeters>(){

            public CachedMeters load(String endpoint) throws Exception {
                return SemanticServiceMetrics.this.metersForEndpoint(endpoint);
            }
        });
    }

    @Override
    public RequestMetrics metricsForEndpointCall(String endpoint) {
        CachedMeters meters = (CachedMeters)this.metersCache.getUnchecked((Object)endpoint);
        return new SemanticRequestMetrics(meters.requestRateCounter, meters.fanoutHistogram, meters.responseSizeHistogram, meters.requestSizeHistogram, meters.requestDurationTimer.map(Timer::time), meters.droppedRequests, meters.sentReplies, meters.sentErrors, meters.sentErrors4xx, meters.sentErrors5xx, meters.requestDurationThresholdTracker);
    }

    private CachedMeters metersForEndpoint(String endpoint) {
        MetricId id = this.metricId.tagged("endpoint", endpoint);
        for (Integer code : this.precreateCodes) {
            this.requestRateMeter(id, code);
        }
        Meter sentReplies = new Meter();
        Meter sentErrors = new Meter();
        Meter sentErrors4xx = new Meter();
        Meter sentErrors5xx = new Meter();
        if (this.enabledMetrics.test(What.ERROR_RATIO)) {
            this.registerRatioGauge(id, "1m", this.errorRatioSupplier(() -> ((Meter)sentErrors).getOneMinuteRate(), () -> ((Meter)sentReplies).getOneMinuteRate()), this.metricRegistry, What.ERROR_RATIO);
            this.registerRatioGauge(id, "5m", this.errorRatioSupplier(() -> ((Meter)sentErrors).getFiveMinuteRate(), () -> ((Meter)sentReplies).getFiveMinuteRate()), this.metricRegistry, What.ERROR_RATIO);
            this.registerRatioGauge(id, "15m", this.errorRatioSupplier(() -> ((Meter)sentErrors).getFifteenMinuteRate(), () -> ((Meter)sentReplies).getFifteenMinuteRate()), this.metricRegistry, What.ERROR_RATIO);
        }
        if (this.enabledMetrics.test(What.ERROR_RATIO_4XX)) {
            this.registerRatioGauge(id, "1m", this.errorRatioSupplier(() -> ((Meter)sentErrors4xx).getOneMinuteRate(), () -> ((Meter)sentReplies).getOneMinuteRate()), this.metricRegistry, What.ERROR_RATIO_4XX);
            this.registerRatioGauge(id, "5m", this.errorRatioSupplier(() -> ((Meter)sentErrors4xx).getFiveMinuteRate(), () -> ((Meter)sentReplies).getFiveMinuteRate()), this.metricRegistry, What.ERROR_RATIO_4XX);
            this.registerRatioGauge(id, "15m", this.errorRatioSupplier(() -> ((Meter)sentErrors4xx).getFifteenMinuteRate(), () -> ((Meter)sentReplies).getFifteenMinuteRate()), this.metricRegistry, What.ERROR_RATIO_4XX);
        }
        if (this.enabledMetrics.test(What.ERROR_RATIO_5XX)) {
            this.registerRatioGauge(id, "1m", this.errorRatioSupplier(() -> ((Meter)sentErrors5xx).getOneMinuteRate(), () -> ((Meter)sentReplies).getOneMinuteRate()), this.metricRegistry, What.ERROR_RATIO_5XX);
            this.registerRatioGauge(id, "5m", this.errorRatioSupplier(() -> ((Meter)sentErrors5xx).getFiveMinuteRate(), () -> ((Meter)sentReplies).getFiveMinuteRate()), this.metricRegistry, What.ERROR_RATIO_5XX);
            this.registerRatioGauge(id, "15m", this.errorRatioSupplier(() -> ((Meter)sentErrors5xx).getFifteenMinuteRate(), () -> ((Meter)sentReplies).getFifteenMinuteRate()), this.metricRegistry, What.ERROR_RATIO_5XX);
        }
        return new CachedMeters(this.requestRateCounter(id), this.fanoutHistogram(id), this.responseSizeHistogram(id), this.requestSizeHistogram(id), this.requestDurationTimer(id), this.requestDurationThresholdTracker(id, endpoint), this.droppedRequests(id), sentReplies, sentErrors, sentErrors4xx, sentErrors5xx);
    }

    private Optional<Meter> droppedRequests(MetricId id) {
        return this.enabledMetrics.test(What.DROPPED_REQUEST_RATE) ? Optional.of(this.metricRegistry.meter(id.tagged("what", What.DROPPED_REQUEST_RATE.tag(), "unit", "request"))) : Optional.empty();
    }

    private Optional<Timer> requestDurationTimer(MetricId id) {
        return this.enabledMetrics.test(What.ENDPOINT_REQUEST_DURATION) ? Optional.of(this.metricRegistry.timer(id.tagged("what", What.ENDPOINT_REQUEST_DURATION.tag()))) : Optional.empty();
    }

    private Optional<DurationThresholdTracker> requestDurationThresholdTracker(MetricId id, String endpoint) {
        return this.durationThresholdConfig.getDurationThresholdForEndpoint(endpoint).map(threshold -> Optional.of(new DurationThresholdTracker(id, this.metricRegistry, (Integer)threshold))).orElse(Optional.empty());
    }

    private Optional<Histogram> requestSizeHistogram(MetricId id) {
        return this.enabledMetrics.test(What.REQUEST_PAYLOAD_SIZE) ? Optional.of(this.metricRegistry.histogram(id.tagged("what", What.REQUEST_PAYLOAD_SIZE.tag(), "unit", "B"))) : Optional.empty();
    }

    private Optional<Histogram> responseSizeHistogram(MetricId id) {
        return this.enabledMetrics.test(What.RESPONSE_PAYLOAD_SIZE) ? Optional.of(this.metricRegistry.histogram(id.tagged("what", What.RESPONSE_PAYLOAD_SIZE.tag(), "unit", "B"))) : Optional.empty();
    }

    private Optional<Histogram> fanoutHistogram(MetricId id) {
        return this.enabledMetrics.test(What.REQUEST_FANOUT_FACTOR) ? Optional.of(this.metricRegistry.histogram(id.tagged("what", What.REQUEST_FANOUT_FACTOR.tag(), "unit", "request/request"))) : Optional.empty();
    }

    private Optional<Consumer<Response<ByteString>>> requestRateCounter(MetricId id) {
        return this.enabledMetrics.test(What.ENDPOINT_REQUEST_RATE) ? Optional.of(response -> this.requestRateMeter(id, response.status().code()).mark()) : Optional.empty();
    }

    private Meter requestRateMeter(MetricId id, int code) {
        return this.metricRegistry.meter(id.tagged("what", What.ENDPOINT_REQUEST_RATE.tag(), "unit", "request", "status-code", String.valueOf(code)));
    }

    private void registerRatioGauge(MetricId metricId, String stat, final Supplier<RatioGauge.Ratio> ratioSupplier, SemanticMetricRegistry metricRegistry, What what) {
        metricRegistry.register(metricId.tagged("what", what.tag(), "stat", stat), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return (RatioGauge.Ratio)ratioSupplier.get();
            }
        });
    }

    private Supplier<RatioGauge.Ratio> errorRatioSupplier(Supplier<Double> errorRateSupplier, Supplier<Double> replyRateSupplier) {
        return () -> {
            double denominator = Math.max((Double)replyRateSupplier.get(), 0.001);
            RatioGauge.Ratio ratio = RatioGauge.Ratio.of((double)((Double)errorRateSupplier.get()), (double)denominator);
            return ratio.getValue() > 1.0E-15 ? ratio : RatioGauge.Ratio.of((double)0.0, (double)denominator);
        };
    }

    private static class CachedMeters {
        private final Optional<Consumer<Response<ByteString>>> requestRateCounter;
        private final Optional<Histogram> fanoutHistogram;
        private final Optional<Histogram> responseSizeHistogram;
        private final Optional<Histogram> requestSizeHistogram;
        private final Optional<Timer> requestDurationTimer;
        private final Optional<DurationThresholdTracker> requestDurationThresholdTracker;
        private final Optional<Meter> droppedRequests;
        private final Meter sentReplies;
        private final Meter sentErrors;
        private final Meter sentErrors4xx;
        private final Meter sentErrors5xx;

        private CachedMeters(Optional<Consumer<Response<ByteString>>> requestRateCounter, Optional<Histogram> fanoutHistogram, Optional<Histogram> responseSizeHistogram, Optional<Histogram> requestSizeHistogram, Optional<Timer> requestDurationTimer, Optional<DurationThresholdTracker> requestDurationThresholdTracker, Optional<Meter> droppedRequests, Meter sentReplies, Meter sentErrors, Meter sentErrors4xx, Meter sentErrors5xx) {
            this.requestRateCounter = requestRateCounter;
            this.fanoutHistogram = fanoutHistogram;
            this.requestSizeHistogram = requestSizeHistogram;
            this.responseSizeHistogram = responseSizeHistogram;
            this.requestDurationTimer = requestDurationTimer;
            this.requestDurationThresholdTracker = requestDurationThresholdTracker;
            this.droppedRequests = droppedRequests;
            this.sentReplies = sentReplies;
            this.sentErrors = sentErrors;
            this.sentErrors4xx = sentErrors4xx;
            this.sentErrors5xx = sentErrors5xx;
        }
    }
}

