/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.spotify.confidence.ConfidenceTypeMapper;
import com.spotify.confidence.ConfidenceUtils;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.EventSender;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.EventSenderEngineImpl;
import com.spotify.confidence.Exceptions;
import com.spotify.confidence.FlagEvaluation;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.FlagResolverClientImpl;
import com.spotify.confidence.GrpcFlagResolver;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolvedFlag;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class Confidence
implements EventSender,
Closeable {
    protected Map<String, ConfidenceValue> context = Maps.newHashMap();
    private static final Logger log = LoggerFactory.getLogger(Confidence.class);

    private Confidence() {
    }

    protected abstract ClientDelegate client();

    protected Stream<Map.Entry<String, ConfidenceValue>> contextEntries() {
        return this.context.entrySet().stream().filter(e -> !((ConfidenceValue)e.getValue()).isNull());
    }

    @Override
    public ConfidenceValue.Struct getContext() {
        return this.contextEntries().collect(Collector.of(ImmutableMap.Builder::new, ImmutableMap.Builder::put, (b1, b2) -> b1.putAll((Map)b2.build()), builder -> ConfidenceValue.Struct.of((Map<String, ConfidenceValue>)builder.build()), new Collector.Characteristics[0]));
    }

    @Override
    public void setContext(ConfidenceValue.Struct context) {
        this.context = Maps.newHashMap(context.asMap());
    }

    @Override
    public void updateContextEntry(String key, ConfidenceValue value) {
        this.context.put(key, value);
    }

    @Override
    public void removeContextEntry(String key) {
        this.context.put(key, ConfidenceValue.NULL_VALUE);
    }

    @Override
    public void clearContext() {
        this.context.clear();
    }

    @Override
    public Confidence withContext(ConfidenceValue.Struct context) {
        ChildInstance child = new ChildInstance(this);
        child.setContext(context);
        return child;
    }

    @Override
    public Confidence withContext(Map<String, ConfidenceValue> context) {
        return this.withContext(ConfidenceValue.of(context));
    }

    @Override
    public void track(String eventName) {
        try {
            this.client().emit(eventName, this.getContext(), Optional.empty());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void track(String eventName, ConfidenceValue.Struct data) {
        if (data.asMap().containsKey("context")) {
            throw new Exceptions.InvalidContextInMessaageError("Field 'context' is not allowed in event's data");
        }
        try {
            this.client().emit(eventName, this.getContext(), Optional.of(data));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public <T> T getValue(String key, T defaultValue) {
        return this.getEvaluation(key, defaultValue).getValue();
    }

    public <T> FlagEvaluation<T> getEvaluation(String key, T defaultValue) {
        try {
            ConfidenceUtils.FlagPath flagPath = ConfidenceUtils.FlagPath.getPath(key);
            String requestFlagName = "flags/" + flagPath.getFlag();
            ResolveFlagsResponse response = this.resolveFlags(requestFlagName, false).get();
            if (response.getResolvedFlagsList().isEmpty()) {
                String errorMessage = String.format("No active flag '%s' was found", flagPath.getFlag());
                log.warn(errorMessage);
                return new FlagEvaluation<T>(defaultValue, "", "ERROR", ErrorType.FLAG_NOT_FOUND, errorMessage);
            }
            ResolvedFlag resolvedFlag = response.getResolvedFlags(0);
            if (!requestFlagName.equals(resolvedFlag.getFlag())) {
                String errorMessage = String.format("Unexpected flag '%s' from remote", resolvedFlag.getFlag().replaceFirst("^flags/", ""));
                log.warn(errorMessage);
                return new FlagEvaluation<T>(defaultValue, "", "ERROR", ErrorType.INTERNAL_ERROR, errorMessage);
            }
            if (resolvedFlag.getVariant().isEmpty()) {
                String errorMessage = String.format("The server returned no assignment for the flag '%s'. Typically, this happens if no configured rules matches the given evaluation context.", flagPath.getFlag());
                log.debug(errorMessage);
                return new FlagEvaluation<T>(defaultValue, "", resolvedFlag.getReason().toString());
            }
            ConfidenceValue confidenceValue = ConfidenceUtils.getValueForPath(flagPath.getPath(), ConfidenceTypeMapper.from(resolvedFlag.getValue(), resolvedFlag.getFlagSchema()));
            return new FlagEvaluation<T>(ConfidenceTypeMapper.getTyped(confidenceValue, defaultValue), resolvedFlag.getVariant(), resolvedFlag.getReason().toString());
        }
        catch (Exceptions.IllegalValuePath | Exceptions.ValueNotFound e) {
            log.warn(e.getMessage());
            return new FlagEvaluation<T>(defaultValue, "", "ERROR", ErrorType.INVALID_VALUE_PATH, e.getMessage());
        }
        catch (Exceptions.IllegalValueType | Exceptions.IncompatibleValueType e) {
            log.warn(e.getMessage());
            return new FlagEvaluation<T>(defaultValue, "", "ERROR", ErrorType.INVALID_VALUE_TYPE, e.getMessage());
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return new FlagEvaluation<T>(defaultValue, "", "ERROR", ErrorType.INTERNAL_ERROR, e.getMessage());
        }
    }

    CompletableFuture<ResolveFlagsResponse> resolveFlags(String flagName, Boolean isProvider) {
        return this.client().resolveFlags(flagName, this.getContext(), isProvider);
    }

    @VisibleForTesting
    static Confidence create(EventSenderEngine eventSenderEngine, FlagResolverClient flagResolverClient) {
        Closer closer = Closer.create();
        closer.register((Closeable)eventSenderEngine);
        closer.register((Closeable)flagResolverClient);
        return new RootInstance(new ClientDelegate((Closeable)closer, flagResolverClient, eventSenderEngine));
    }

    public static Builder builder(String clientSecret) {
        return new Builder(clientSecret);
    }

    private static class ChildInstance
    extends Confidence {
        private final Confidence parent;
        private boolean closed = false;

        private ChildInstance(Confidence parent) {
            this.parent = parent;
        }

        @Override
        protected Stream<Map.Entry<String, ConfidenceValue>> contextEntries() {
            Set ownKeys = this.context.keySet();
            return Stream.concat(this.parent.contextEntries().filter(entry -> !ownKeys.contains(entry.getKey())), super.contextEntries());
        }

        @Override
        protected ClientDelegate client() {
            if (this.closed) {
                throw new IllegalStateException("Resource closed");
            }
            return this.parent.client();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public void flush() {
            this.parent.flush();
        }
    }

    private static class ClientDelegate
    implements FlagResolverClient,
    EventSenderEngine {
        private final Closeable closeable;
        private final FlagResolverClient flagResolverClient;
        private final EventSenderEngine eventSenderEngine;

        private ClientDelegate(Closeable closeable, FlagResolverClient flagResolverClient, EventSenderEngine eventSenderEngine) {
            this.closeable = closeable;
            this.flagResolverClient = flagResolverClient;
            this.eventSenderEngine = eventSenderEngine;
        }

        @Override
        public void emit(String name, ConfidenceValue.Struct context, Optional<ConfidenceValue.Struct> message) {
            this.eventSenderEngine.emit(name, context, message);
        }

        @Override
        public void flush() {
            this.eventSenderEngine.flush();
        }

        @Override
        public CompletableFuture<ResolveFlagsResponse> resolveFlags(String flag, ConfidenceValue.Struct context, Boolean isProvider) {
            return this.flagResolverClient.resolveFlags(flag, context, isProvider);
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }
    }

    private static class RootInstance
    extends Confidence {
        @Nullable
        private ClientDelegate client;

        private RootInstance(ClientDelegate client) {
            this.client = client;
        }

        @Override
        protected ClientDelegate client() {
            if (this.client == null) {
                throw new IllegalStateException("Resource closed");
            }
            return this.client;
        }

        @Override
        public void close() throws IOException {
            try {
                this.client().close();
            }
            finally {
                this.client = null;
            }
        }

        @Override
        public void flush() {
            this.client.flush();
        }
    }

    public static class Builder {
        private final String clientSecret;
        private final Closer closer = Closer.create();
        private final ManagedChannel DEFAULT_CHANNEL;
        private ManagedChannel flagResolverManagedChannel = this.DEFAULT_CHANNEL = ManagedChannelBuilder.forAddress((String)"edge-grpc.spotify.com", (int)443).keepAliveTime(Duration.ofMinutes(5L).getSeconds(), TimeUnit.SECONDS).build();

        public Builder(@Nonnull String clientSecret) {
            this.clientSecret = clientSecret;
            this.registerChannelForShutdown(this.DEFAULT_CHANNEL);
        }

        public Builder flagResolverManagedChannel(String host, int port) {
            this.flagResolverManagedChannel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
            this.registerChannelForShutdown(this.flagResolverManagedChannel);
            return this;
        }

        public Builder flagResolverManagedChannel(ManagedChannel managedChannel) {
            this.flagResolverManagedChannel = managedChannel;
            return this;
        }

        public Confidence build() {
            FlagResolverClientImpl flagResolverClient = new FlagResolverClientImpl(new GrpcFlagResolver(this.clientSecret, this.flagResolverManagedChannel));
            EventSenderEngineImpl eventSenderEngine = new EventSenderEngineImpl(this.clientSecret, this.DEFAULT_CHANNEL, Instant::now);
            this.closer.register((Closeable)flagResolverClient);
            this.closer.register((Closeable)eventSenderEngine);
            return new RootInstance(new ClientDelegate((Closeable)this.closer, flagResolverClient, eventSenderEngine));
        }

        private void registerChannelForShutdown(ManagedChannel channel) {
            this.closer.register(() -> {
                channel.shutdown();
                try {
                    channel.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    channel.shutdownNow();
                }
            });
        }
    }
}

