/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.Exceptions;
import com.spotify.confidence.shaded.flags.types.v1.FlagSchema;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ConfidenceTypeMapper {
    ConfidenceTypeMapper() {
    }

    private static ConfidenceValue from(Value value, FlagSchema schema) throws Exceptions.ParseError {
        if (schema.getSchemaTypeCase() == FlagSchema.SchemaTypeCase.SCHEMATYPE_NOT_SET) {
            throw new Exceptions.ParseError("schemaType not set in FlagSchema");
        }
        String mismatchPrefix = "Mismatch between schema and value:";
        switch (value.getKindCase()) {
            case NULL_VALUE: {
                return ConfidenceValue.NULL_VALUE;
            }
            case NUMBER_VALUE: {
                switch (schema.getSchemaTypeCase()) {
                    case INT_SCHEMA: {
                        int intVal = (int)value.getNumberValue();
                        if ((double)intVal != value.getNumberValue()) {
                            throw new Exceptions.ParseError(String.format("%s %s should be an int, but it is a double/long", "Mismatch between schema and value:", value));
                        }
                        return ConfidenceValue.of(intVal);
                    }
                    case DOUBLE_SCHEMA: {
                        return ConfidenceValue.of(value.getNumberValue());
                    }
                }
                throw new Exceptions.ParseError(String.format("%s %s is a Number, but it should be %s", new Object[]{"Mismatch between schema and value:", value, schema.getSchemaTypeCase()}));
            }
            case STRING_VALUE: {
                if (schema.getSchemaTypeCase() != FlagSchema.SchemaTypeCase.STRING_SCHEMA) {
                    throw new Exceptions.ParseError(String.format("%s %s is a String, but it should be %s", new Object[]{"Mismatch between schema and value:", value, schema.getSchemaTypeCase()}));
                }
                return ConfidenceValue.of(value.getStringValue());
            }
            case BOOL_VALUE: {
                if (schema.getSchemaTypeCase() != FlagSchema.SchemaTypeCase.BOOL_SCHEMA) {
                    throw new Exceptions.ParseError(String.format("%s %s is a Bool, but it should be %s", new Object[]{"Mismatch between schema and value:", value, schema.getSchemaTypeCase()}));
                }
                return ConfidenceValue.of(value.getBoolValue());
            }
            case STRUCT_VALUE: {
                if (schema.getSchemaTypeCase() != FlagSchema.SchemaTypeCase.STRUCT_SCHEMA) {
                    throw new Exceptions.ParseError(String.format("%s %s is a Struct, but it should be %s", new Object[]{"Mismatch between schema and value:", value, schema.getSchemaTypeCase()}));
                }
                return ConfidenceTypeMapper.from(value.getStructValue(), schema.getStructSchema());
            }
            case LIST_VALUE: {
                if (schema.getSchemaTypeCase() != FlagSchema.SchemaTypeCase.LIST_SCHEMA) {
                    throw new Exceptions.ParseError(String.format("%s %s is a List, but it should be %s", new Object[]{"Mismatch between schema and value:", value, schema.getSchemaTypeCase()}));
                }
                List<ConfidenceValue> mappedList = value.getListValue().getValuesList().stream().map(val -> ConfidenceTypeMapper.from(val, schema.getListSchema().getElementSchema())).collect(Collectors.toList());
                return ConfidenceValue.of(mappedList);
            }
            case KIND_NOT_SET: {
                throw new Exceptions.ParseError("kind not set in com.google.protobuf.Value");
            }
        }
        throw new Exceptions.ParseError("Unknown value type");
    }

    public static ConfidenceValue from(Struct struct, FlagSchema.StructFlagSchema schema) {
        Map<String, ConfidenceValue> map = struct.getFieldsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (schema.getSchemaMap().containsKey(entry.getKey())) {
                return ConfidenceTypeMapper.from((Value)entry.getValue(), schema.getSchemaMap().get(entry.getKey()));
            }
            throw new Exceptions.ParseError(String.format("Lacking schema for field '%s'", entry.getKey()));
        }));
        return ConfidenceValue.Struct.ofMap(map);
    }

    public static <T> T getTyped(ConfidenceValue value, T defaultValue) throws Exceptions.IllegalValueType, Exceptions.IncompatibleValueType {
        if (value.equals(ConfidenceValue.NULL_VALUE)) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            if (value.isString()) {
                return (T)value.asString();
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        if (defaultValue instanceof Integer) {
            if (value.isInteger()) {
                return (T)Integer.valueOf(value.asInteger());
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        if (defaultValue instanceof Double) {
            if (value.isDouble()) {
                return (T)Double.valueOf(value.asDouble());
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        if (defaultValue instanceof Boolean) {
            if (value.isBoolean()) {
                return (T)Boolean.valueOf(value.asBoolean());
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        if (defaultValue instanceof ConfidenceValue.List) {
            if (value.isList()) {
                return (T)value.asList();
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default value type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        if (defaultValue instanceof ConfidenceValue.Struct) {
            if (value.isStruct()) {
                return (T)value.asStruct();
            }
            throw new Exceptions.IncompatibleValueType(String.format("Default value type %s, but value of type %s", defaultValue.getClass(), value.getClass()));
        }
        throw new Exceptions.IllegalValueType(String.format("Illegal value type: %s", defaultValue.getClass()));
    }
}

