/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.Exceptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfidenceUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfidenceUtils.class);

    private ConfidenceUtils() {
    }

    static ConfidenceValue getValueForPath(List<String> path, ConfidenceValue fullValue) throws Exceptions.ValueNotFound {
        ConfidenceValue value = fullValue;
        for (String fieldName : path) {
            ConfidenceValue.Struct structure = value.asStruct();
            if (structure == null) {
                log.warn("Illegal attempt to derive field '{}' on non-structure value '{}'", (Object)fieldName, (Object)value);
                throw new Exceptions.ValueNotFound(String.format("Illegal attempt to derive field '%s' on non-structure value '%s'", fieldName, value));
            }
            value = structure.get(fieldName);
            if (value != null) continue;
            log.warn("Illegal attempt to derive non-existing field '{}' on structure value '{}'", (Object)fieldName, (Object)structure);
            throw new Exceptions.ValueNotFound(String.format("Illegal attempt to derive non-existing field '%s' on structure value '%s'", fieldName, structure));
        }
        return value;
    }

    static String getSdkVersion() {
        try {
            Properties prop = new Properties();
            prop.load(ConfidenceUtils.class.getResourceAsStream("/version.properties"));
            return prop.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException("Can't determine version of the SDK", e);
        }
    }

    static class FlagPath {
        private final String flag;
        private final List<String> path;

        public FlagPath(String flag, List<String> path) {
            this.flag = flag;
            this.path = path;
        }

        public String getFlag() {
            return this.flag;
        }

        public List<String> getPath() {
            return this.path;
        }

        public static FlagPath getPath(String str) throws Exceptions.IllegalValuePath {
            String regex = Pattern.quote(".");
            String[] parts = str.split(regex);
            if (parts.length == 0) {
                log.warn("Illegal path string '{}'", (Object)str);
                throw new Exceptions.IllegalValuePath(String.format("Illegal path string '%s'", str));
            }
            if (parts.length == 1) {
                return new FlagPath(str, List.of());
            }
            return new FlagPath(parts[0], Arrays.asList(parts).subList(1, parts.length));
        }
    }
}

