/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import java.util.stream.Collectors;

@Beta
public abstract class ConfidenceValue {
    static final ConfidenceValue NULL_VALUE = new ConfidenceValue(){

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
    };

    private ConfidenceValue() {
    }

    public boolean isStruct() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isTimestamp() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public Struct asStruct() {
        throw new IllegalStateException("Not a StructValue");
    }

    public String asString() {
        throw new IllegalStateException("Not a StringValue");
    }

    public int asInteger() {
        throw new IllegalStateException("Not a IntegerValue");
    }

    public double asDouble() {
        throw new IllegalStateException("Not a DoubleValue");
    }

    public Instant asInstant() {
        throw new IllegalStateException("Not a InstantValue");
    }

    public LocalDate asLocalDate() {
        throw new IllegalStateException("Not a DateValue");
    }

    public boolean asBoolean() {
        throw new IllegalStateException("Not a BooleanValue");
    }

    public java.util.List<ConfidenceValue> asList() {
        throw new IllegalStateException("Not a ListValue");
    }

    public static ConfidenceValue of(int value) {
        return new Integer(value);
    }

    public static ConfidenceValue of(double value) {
        return new Double(value);
    }

    public static ConfidenceValue of(Instant value) {
        return new Timestamp(value);
    }

    public static ConfidenceValue of(LocalDate date) {
        return new Date(date);
    }

    public static ConfidenceValue of(String value) {
        return new StringValue(value);
    }

    public static ConfidenceValue of(boolean value) {
        return new BooleanValue(value);
    }

    public static List of(java.util.List<ConfidenceValue> values) {
        return new List(values);
    }

    public static List ofStrings(java.util.List<String> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static List ofBooleans(java.util.List<Boolean> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static List ofIntegers(java.util.List<java.lang.Integer> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static List ofDoubles(java.util.List<java.lang.Double> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static List ofTimestamps(java.util.List<Instant> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static List ofDates(java.util.List<LocalDate> values) {
        return new List(values.stream().map(ConfidenceValue::of).collect(Collectors.toList()));
    }

    public static Struct of(Map<String, ConfidenceValue> values) {
        return new Struct(values);
    }

    static ConfidenceValue fromProto(Value protoValue) {
        Value.KindCase kind = protoValue.getKindCase();
        switch (kind) {
            case BOOL_VALUE: {
                return ConfidenceValue.of(protoValue.getBoolValue());
            }
            case NUMBER_VALUE: {
                return ConfidenceValue.of(protoValue.getNumberValue());
            }
            case STRING_VALUE: {
                String stringValue = protoValue.getStringValue();
                try {
                    return ConfidenceValue.of(Instant.parse(stringValue));
                }
                catch (Exception e1) {
                    try {
                        return ConfidenceValue.of(LocalDate.parse(stringValue));
                    }
                    catch (Exception e2) {
                        return ConfidenceValue.of(stringValue);
                    }
                }
            }
            case NULL_VALUE: {
                return NULL_VALUE;
            }
            case STRUCT_VALUE: {
                return Struct.fromProto(protoValue.getStructValue());
            }
            case LIST_VALUE: {
                java.util.List<ConfidenceValue> list = protoValue.getListValue().getValuesList().stream().map(ConfidenceValue::fromProto).collect(Collectors.toList());
                return new List(list);
            }
        }
        throw new IllegalArgumentException("Unsupported value kind:" + kind);
    }

    public abstract Value toProto();

    public int hashCode() {
        return this.toProto().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.toProto().equals((Object)((ConfidenceValue)obj).toProto());
    }

    public static class Integer
    extends ConfidenceValue {
        private final int value;

        private Integer(int value) {
            this.value = value;
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        public int asInteger() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setNumberValue((double)this.value).build();
        }
    }

    public static class Double
    extends ConfidenceValue {
        private final double value;

        private Double(double value) {
            this.value = value;
        }

        @Override
        public boolean isDouble() {
            return true;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setNumberValue(this.value).build();
        }
    }

    public static class Timestamp
    extends ConfidenceValue {
        private final Instant value;

        private Timestamp(Instant value) {
            this.value = value;
        }

        @Override
        public boolean isTimestamp() {
            return true;
        }

        @Override
        public Instant asInstant() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setStringValue(this.value.toString()).build();
        }
    }

    public static class Date
    extends ConfidenceValue {
        private final LocalDate value;

        private Date(LocalDate value) {
            this.value = value;
        }

        @Override
        public boolean isDate() {
            return true;
        }

        @Override
        public LocalDate asLocalDate() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setStringValue(this.value.toString()).build();
        }
    }

    public static class StringValue
    extends ConfidenceValue {
        private final String value;

        private StringValue(String value) {
            this.value = value;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setStringValue(this.value).build();
        }

        public String toString() {
            return this.value;
        }
    }

    public static class BooleanValue
    extends ConfidenceValue {
        private final boolean value;

        private BooleanValue(boolean value) {
            this.value = value;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public Value toProto() {
            return Value.newBuilder().setBoolValue(this.value).build();
        }
    }

    public static class List
    extends ConfidenceValue {
        private final ImmutableList<ConfidenceValue> values;

        private List(java.util.List<ConfidenceValue> values) {
            this.values = ImmutableList.copyOf(values);
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public java.util.List<ConfidenceValue> asList() {
            return ImmutableList.copyOf(this.values);
        }

        public String toString() {
            return "[" + this.values + "]";
        }

        @Override
        public Value toProto() {
            ListValue value = ListValue.newBuilder().addAllValues((Iterable)this.values.stream().map(ConfidenceValue::toProto).collect(Collectors.toList())).build();
            return Value.newBuilder().setListValue(value).build();
        }

        static List fromProto(ListValue list) {
            return new List(list.getValuesList().stream().map(ConfidenceValue::fromProto).collect(Collectors.toList()));
        }
    }

    public static class Struct
    extends ConfidenceValue {
        public static final Struct EMPTY = new Struct((Map<String, ConfidenceValue>)ImmutableMap.of());
        private final ImmutableMap<String, ConfidenceValue> values;

        protected Struct(Map<String, ConfidenceValue> values) {
            this.values = ImmutableMap.copyOf(values);
        }

        @Override
        public boolean isStruct() {
            return true;
        }

        @Override
        public Struct asStruct() {
            return new Struct((Map<String, ConfidenceValue>)this.values);
        }

        public ConfidenceValue get(String ... path) {
            ConfidenceValue value = this;
            for (int i = 0; i < path.length; ++i) {
                if (!((ConfidenceValue)value).isStruct()) {
                    throw new IllegalStateException();
                }
                value = (ConfidenceValue)this.values.getOrDefault((Object)path[i], null);
            }
            return value;
        }

        public String toString() {
            return this.values.toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Value toProto() {
            Struct.Builder builder = com.google.protobuf.Struct.newBuilder();
            this.values.forEach((key, value) -> builder.putFields(key, value.toProto()));
            return Value.newBuilder().setStructValue(builder).build();
        }

        static Struct fromProto(com.google.protobuf.Struct struct) {
            return new Struct(Maps.transformValues((Map)struct.getFieldsMap(), ConfidenceValue::fromProto));
        }

        static Struct ofMap(Map<String, ConfidenceValue> map) {
            return new Struct(map);
        }

        public Map<String, ConfidenceValue> asMap() {
            return this.values;
        }

        public Map<String, Value> asProtoMap() {
            return this.values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfidenceValue)e.getValue()).toProto()));
        }

        public static final class Builder {
            private final ImmutableMap.Builder<String, ConfidenceValue> builder = ImmutableMap.builder();

            public Builder set(String key, ConfidenceValue value) {
                this.builder.put((Object)key, (Object)value);
                return this;
            }

            public Builder set(String key, int value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder set(String key, double value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder set(String key, Instant value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder set(String key, LocalDate value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder set(String key, String value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder set(String key, boolean value) {
                return this.set(key, ConfidenceValue.of(value));
            }

            public Builder setIntegers(String key, java.util.List<java.lang.Integer> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofIntegers(values));
                return this;
            }

            public Builder setDoubles(String key, java.util.List<java.lang.Double> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofDoubles(values));
                return this;
            }

            public Builder setTimestamps(String key, java.util.List<Instant> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofTimestamps(values));
                return this;
            }

            public Builder setDates(String key, java.util.List<LocalDate> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofDates(values));
                return this;
            }

            public Builder setStrings(String key, java.util.List<String> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofStrings(values));
                return this;
            }

            public Builder setBooleans(String key, java.util.List<Boolean> values) {
                this.builder.put((Object)key, (Object)ConfidenceValue.ofBooleans(values));
                return this;
            }

            public Builder set(String key, Builder value) {
                return this.set(key, value.build());
            }

            public Struct build() {
                return new Struct((Map<String, ConfidenceValue>)this.builder.build());
            }
        }
    }
}

