/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.ErrorType;
import java.util.Optional;
import javax.annotation.Nonnull;

public class FlagEvaluation<T> {
    private T value;
    private String variant;
    private String reason;
    private Optional<ErrorType> errorType;
    private Optional<String> errorMessage;

    public FlagEvaluation(@Nonnull T value, @Nonnull String variant, @Nonnull String reason, @Nonnull ErrorType errorType, @Nonnull String errorMessage) {
        this.value = value;
        this.variant = variant;
        this.reason = reason;
        this.errorType = Optional.of(errorType);
        this.errorMessage = Optional.of(errorMessage);
    }

    public FlagEvaluation(@Nonnull T value, @Nonnull String variant, @Nonnull String reason) {
        this.value = value;
        this.variant = variant;
        this.reason = reason;
        this.errorType = Optional.empty();
        this.errorMessage = Optional.empty();
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Optional<ErrorType> getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = Optional.of(errorType);
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = Optional.of(errorMessage);
    }

    public String toString() {
        return "FlagEvaluation{value=" + this.value + ", variant='" + this.variant + "', reason='" + this.reason + "', errorType=" + this.errorType + ", errorMessage='" + this.errorMessage.orElse("") + "'}";
    }
}

