/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.FlagResolver;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import java.util.concurrent.CompletableFuture;

class FlagResolverClientImpl
implements FlagResolverClient {
    public static final String OPEN_FEATURE_RESOLVE_CONTEXT_KEY = "open-feature";
    private final FlagResolver grpcFlagResolver;

    public FlagResolverClientImpl(FlagResolver grpcFlagResolver) {
        this.grpcFlagResolver = grpcFlagResolver;
    }

    @Override
    public CompletableFuture<ResolveFlagsResponse> resolveFlags(String flagName, ConfidenceValue.Struct context, Boolean isProvider) {
        Struct.Builder evaluationContextBuilder = context.toProto().getStructValue().toBuilder();
        if (context.asMap().containsKey(OPEN_FEATURE_RESOLVE_CONTEXT_KEY)) {
            Value openFeatureEvaluationContext = context.asMap().get(OPEN_FEATURE_RESOLVE_CONTEXT_KEY).toProto();
            evaluationContextBuilder.putAllFields(openFeatureEvaluationContext.getStructValue().getFieldsMap());
            evaluationContextBuilder.removeFields(OPEN_FEATURE_RESOLVE_CONTEXT_KEY);
        }
        return this.grpcFlagResolver.resolve(flagName, evaluationContextBuilder.build(), isProvider);
    }

    @Override
    public void close() {
        this.grpcFlagResolver.close();
    }
}

